/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveEnableFeaturePreview
extends Recipe {
    @Option(displayName="The feature preview name", description="The name of the feature preview to remove.", example="ONE_LOCKFILE_PER_PROJECT")
    private final String previewFeatureName;

    public String getDisplayName() {
        return "Remove an enabled Gradle preview feature";
    }

    public String getDescription() {
        return "Remove an enabled Gradle preview feature from `settings.gradle`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if ("enableFeaturePreview".equals(method.getSimpleName()) && method.getArguments().size() == 1 && J.Literal.isLiteralValue((Expression)((Expression)method.getArguments().get(0)), (Object)RemoveEnableFeaturePreview.this.previewFeatureName)) {
                    return null;
                }
                return method;
            }
        });
    }

    @Generated
    public RemoveEnableFeaturePreview(String previewFeatureName) {
        this.previewFeatureName = previewFeatureName;
    }

    @Generated
    public String getPreviewFeatureName() {
        return this.previewFeatureName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveEnableFeaturePreview(previewFeatureName=" + this.getPreviewFeatureName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveEnableFeaturePreview)) {
            return false;
        }
        RemoveEnableFeaturePreview other = (RemoveEnableFeaturePreview)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$previewFeatureName = this.getPreviewFeatureName();
        String other$previewFeatureName = other.getPreviewFeatureName();
        return !(this$previewFeatureName == null ? other$previewFeatureName != null : !this$previewFeatureName.equals(other$previewFeatureName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveEnableFeaturePreview;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $previewFeatureName = this.getPreviewFeatureName();
        result = result * 59 + ($previewFeatureName == null ? 43 : $previewFeatureName.hashCode());
        return result;
    }
}

