/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.style;

import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfStyle
extends StyleStyleElement {
    private static final Logger LOG = Logger.getLogger(OdfStyle.class.getName());
    private static final long serialVersionUID = 1114614579014922410L;

    public OdfStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    @Override
    public OdfStyleBase getParentStyle() {
        String parent = this.getStyleParentStyleNameAttribute();
        OdfStyleBase parentStyle = null;
        if (parent != null && parent.length() != 0) {
            parentStyle = ((OdfSchemaDocument)this.mPackageDocument).getDocumentStyles().getStyle(parent, this.getFamily());
        } else {
            OdfOfficeStyles documentStyles = ((OdfSchemaDocument)this.mPackageDocument).getDocumentStyles();
            if (documentStyles != null) {
                parentStyle = documentStyles.getDefaultStyle(this.getFamily());
            }
        }
        return parentStyle;
    }

    @Override
    public OdfStyleFamily getFamily() {
        String family = this.getStyleFamilyAttribute();
        if (family != null) {
            return OdfStyleFamily.valueOf(family);
        }
        return null;
    }

    public boolean hasPropertyAttribute() {
        boolean hasPropertyAttributes = false;
        NodeList children = this.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || !OdfStylePropertiesBase.class.isInstance(child) || !OdfStyle.hasPropertyAttributes((OdfElement)((Object)child))) continue;
            hasPropertyAttributes = true;
            break;
        }
        return hasPropertyAttributes;
    }

    private static boolean hasPropertyAttributes(OdfElement propsElement) {
        boolean hasPropertyAttributes = false;
        NamedNodeMap attrs = propsElement.getAttributes();
        int attrsCount = attrs.getLength();
        for (int i = 0; i < attrsCount; ++i) {
            Attr a = (Attr)attrs.item(i);
            if (a.getNamespaceURI().equals(OdfDocumentNamespace.STYLE.getUri())) {
                if (a.getLocalName().equals("family") || a.getLocalName().equals("name") || a.getLocalName().equals("parent-style-name") || a.getValue().equals("null")) continue;
                hasPropertyAttributes = true;
                break;
            }
            if (a.getValue().equals("null")) continue;
            hasPropertyAttributes = true;
            break;
        }
        return hasPropertyAttributes;
    }

    public static OdfStylableElement mergeSelectionWithSameRange(OdfStylableElement higherPrioSpan, OdfStylableElement lowerPrioSpan) {
        if (higherPrioSpan != null && lowerPrioSpan != null) {
            OdfStyle newAutoStyle;
            NodeList textPropsChildren;
            boolean innerHasAutomatic = higherPrioSpan.hasAutomaticStyle();
            boolean innerHasTemplate = higherPrioSpan.hasDocumentStyle();
            boolean outerHasAutomatic = lowerPrioSpan.hasAutomaticStyle();
            boolean outerHasTemplate = lowerPrioSpan.hasDocumentStyle();
            OdfOfficeAutomaticStyles autoStyles = lowerPrioSpan.getOrCreateAutomaticStyles();
            if (autoStyles == null) {
                OdfFileDom fileDom = (OdfFileDom)((Object)lowerPrioSpan.getOwnerDocument());
                autoStyles = fileDom instanceof OdfContentDom ? ((OdfContentDom)fileDom).getOrCreateAutomaticStyles() : ((OdfStylesDom)fileDom).getOrCreateAutomaticStyles();
            }
            OdfStyle innerAutoStyle = higherPrioSpan.getAutomaticStyle();
            OdfStyle outerAutoStyle = lowerPrioSpan.getAutomaticStyle();
            StyleTextPropertiesElement innerPropsElement = null;
            if (innerAutoStyle != null) {
                innerPropsElement = (StyleTextPropertiesElement)((Object)innerAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                if (innerPropsElement != null) {
                    textPropsChildren = innerPropsElement.getChildNodes();
                    if (textPropsChildren == null || textPropsChildren.getLength() == 0 && !OdfStyle.hasPropertyAttributes(innerPropsElement)) {
                        innerHasAutomatic = false;
                    }
                } else {
                    innerAutoStyle.appendChild((Node)((Object)new StyleTextPropertiesElement((OdfFileDom)((Object)higherPrioSpan.getOwnerDocument()))));
                    innerHasAutomatic = false;
                }
            } else {
                innerHasAutomatic = false;
            }
            if (outerAutoStyle != null) {
                StyleTextPropertiesElement outerPropsElement = (StyleTextPropertiesElement)((Object)outerAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                if (outerPropsElement != null) {
                    textPropsChildren = outerPropsElement.getChildNodes();
                    if (textPropsChildren == null || textPropsChildren.getLength() == 0 && !OdfStyle.hasPropertyAttributes(outerPropsElement)) {
                        outerHasAutomatic = false;
                    }
                } else {
                    outerAutoStyle.appendChild((Node)((Object)new StyleTextPropertiesElement((OdfFileDom)((Object)lowerPrioSpan.getOwnerDocument()))));
                    outerHasAutomatic = false;
                }
            } else {
                outerHasAutomatic = false;
            }
            if (!innerHasAutomatic && !innerHasTemplate || !outerHasAutomatic && !outerHasTemplate) {
                if (outerHasAutomatic || outerHasTemplate) {
                    higherPrioSpan.setStyleName(lowerPrioSpan.getStyleName());
                }
            } else if (innerHasAutomatic && !innerHasTemplate) {
                if (outerHasAutomatic && !outerHasTemplate) {
                    newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                    StyleTextPropertiesElement newPropsElement = (StyleTextPropertiesElement)((Object)newAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                    OdfElement.copyAttributes(innerPropsElement, newPropsElement);
                    higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
                } else if (!outerHasAutomatic && outerHasTemplate) {
                    newAutoStyle = autoStyles.makeStyleUnique(innerAutoStyle);
                    String parentStyle = outerAutoStyle == null ? lowerPrioSpan.getStyleName() : outerAutoStyle.getStyleParentStyleNameAttribute();
                    newAutoStyle.setStyleParentStyleNameAttribute(parentStyle);
                    higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
                } else {
                    newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                    StyleTextPropertiesElement newPropsElement = (StyleTextPropertiesElement)((Object)newAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                    OdfElement.copyAttributes(innerPropsElement, newPropsElement);
                    newAutoStyle.setStyleParentStyleNameAttribute(innerAutoStyle.getStyleParentStyleNameAttribute());
                    higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
                }
            } else if (!innerHasAutomatic && innerHasTemplate) {
                if (outerHasAutomatic && !outerHasTemplate) {
                    newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                    newAutoStyle.setStyleParentStyleNameAttribute(higherPrioSpan.getStyleName());
                    higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
                } else if (outerHasAutomatic || !outerHasTemplate) {
                    newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                    newAutoStyle.setStyleParentStyleNameAttribute(higherPrioSpan.getStyleName());
                    higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
                }
            } else if (outerHasAutomatic && !outerHasTemplate) {
                newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                StyleTextPropertiesElement newPropsElement = (StyleTextPropertiesElement)((Object)newAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                OdfElement.copyAttributes(innerPropsElement, newPropsElement);
                newAutoStyle.setStyleParentStyleNameAttribute(innerAutoStyle.getStyleParentStyleNameAttribute());
                higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
            } else if (outerHasAutomatic || !outerHasTemplate) {
                newAutoStyle = autoStyles.makeStyleUnique(outerAutoStyle);
                StyleTextPropertiesElement newPropsElement = (StyleTextPropertiesElement)((Object)newAutoStyle.getChildElement(StyleTextPropertiesElement.ELEMENT_NAME.getUri(), StyleTextPropertiesElement.ELEMENT_NAME.getLocalName(), 0));
                OdfElement.copyAttributes(innerPropsElement, newPropsElement);
                newAutoStyle.setStyleParentStyleNameAttribute(innerAutoStyle.getStyleParentStyleNameAttribute());
                higherPrioSpan.setStyleName(newAutoStyle.getStyleNameAttribute());
            }
            OdfElement.removeSingleElement((Element)((Object)lowerPrioSpan));
        }
        return higherPrioSpan;
    }

    @Override
    public String toString() {
        return "[name: " + this.getStyleNameAttribute() + " family: " + this.getStyleFamilyAttribute() + "]";
    }
}

