/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.UnhandledException;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.jdbc.WikittyServiceJDBC;
import org.nuiton.wikitty.ui.Data;
import org.nuiton.wikitty.ui.ProxyModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.Button;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class LoginController
extends GenericForwardComposer {
    protected ProxyModel _proxyModel = new ProxyModel();
    protected Listbox dataList;
    protected ApplicationConfig _config = new ApplicationConfig();
    protected Properties _properties = new Properties();

    public LoginController() throws IOException {
        this.initConfig();
        this.loadProperties();
        this.createProxyDatas();
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        Window window = (Window)comp;
        Groupbox box = (Groupbox)window.getFellow("loginPassword");
        box.setVisible(false);
        this.disableUpdateButtons();
    }

    public void initConfig() {
        this._config.setConfigFileName("wikitty-ui-zk.properties");
        try {
            this._config.parse(new String[0]);
        }
        catch (ArgumentsParserException ex) {
            throw new UnhandledException((Throwable)ex);
        }
    }

    protected void disableUpdateButtons() {
        Button update = (Button)this.self.getFellow("update");
        if (!update.isDisabled()) {
            update.setDisabled(true);
        }
        if (!(update = (Button)this.self.getFellow("distantUpdate")).isDisabled()) {
            update.setDisabled(true);
        }
    }

    protected void enableLocalUpdateButton() {
        Button update = (Button)this.self.getFellow("update");
        if (update.isDisabled()) {
            update.setDisabled(false);
        }
    }

    protected void enableDistantUpdateButton() {
        Button update = (Button)this.self.getFellow("distantUpdate");
        if (update.isDisabled()) {
            update.setDisabled(false);
        }
    }

    protected void saveNewData(Data data) throws FileNotFoundException, IOException {
        String url;
        String solr;
        String driver;
        String name = "";
        String path = "";
        int count = 0;
        while (name != null) {
            path = "data" + count;
            name = this._properties.getProperty(path + ".name");
            ++count;
        }
        this._properties.setProperty(path + ".name", data.getName());
        String db = data.getDb();
        if (!db.isEmpty()) {
            this._properties.setProperty(path + ".db", db);
        }
        if (!(driver = data.getDriver()).isEmpty()) {
            this._properties.setProperty(path + ".driver", driver);
        }
        if (!(solr = data.getSolr()).isEmpty()) {
            this._properties.setProperty(path + ".solr", solr);
        }
        if (!(url = data.getUrl()).isEmpty()) {
            this._properties.setProperty(path + ".url", url);
        }
        String login = data.getLogin();
        String password = data.getPassword();
        if (!login.isEmpty()) {
            this._properties.setProperty(path + ".login", login);
            this._properties.setProperty(path + ".password", password);
        }
        data.setPath(path);
        this.saveProperties();
        this.createProxyDatas();
    }

    protected void saveUpdateData(Data data) throws IOException {
        String url;
        String solr;
        String driver;
        String path = data.getPath();
        this._properties.setProperty(path + ".name", data.getName());
        String db = data.getDb();
        if (!db.isEmpty()) {
            this._properties.setProperty(path + ".db", db);
        }
        if (!(driver = data.getDriver()).isEmpty()) {
            this._properties.setProperty(path + ".driver", driver);
        }
        if (!(solr = data.getSolr()).isEmpty()) {
            this._properties.setProperty(path + ".solr", solr);
        }
        if (!(url = data.getUrl()).isEmpty()) {
            this._properties.setProperty(path + ".url", url);
        }
        this.saveProperties();
        this.createProxyDatas();
    }

    protected void loadProperties() throws IOException {
        String filePath = this._config.getOption("wikitty-ui-zk.filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream stream = new FileInputStream(file);
        this._properties.load(stream);
        ((InputStream)stream).close();
    }

    protected void saveProperties() throws IOException {
        String filePath = this._config.getOption("wikitty-ui-zk.filePath");
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file);
        this._properties.store(stream, null);
        ((OutputStream)stream).close();
    }

    protected void createProxyDatas() {
        ArrayList<Data> datas = new ArrayList<Data>();
        String name = "";
        int count = 0;
        while (name != null) {
            String path = "data" + count;
            name = this._properties.getProperty(path + ".name");
            if (name != null) {
                String db = this._properties.getProperty(path + ".db");
                String solr = this._properties.getProperty(path + ".solr");
                String driver = this._properties.getProperty(path + ".driver");
                String url = this._properties.getProperty(path + ".url");
                String login = this._properties.getProperty(path + ".login");
                String password = this._properties.getProperty(path + ".password");
                Data data = new Data(name, db, driver, solr, url, login, password);
                data.setPath(path);
                datas.add(data);
            }
            ++count;
        }
        this._proxyModel.setProxyDatas(datas);
    }

    protected void removeDataFromProperties(Data data) {
        String path = data.getPath();
        if (this._properties.containsKey(path + ".name")) {
            this._properties.remove(path + ".name");
        }
        if (this._properties.containsKey(path + ".db")) {
            this._properties.remove(path + ".db");
        }
        if (this._properties.containsKey(path + ".driver")) {
            this._properties.remove(path + ".driver");
        }
        if (this._properties.containsKey(path + ".solr")) {
            this._properties.remove(path + ".solr");
        }
        if (this._properties.containsKey(path + ".url")) {
            this._properties.remove(path + ".url");
        }
        if (this._properties.containsKey(path + ".login")) {
            this._properties.remove(path + ".login");
        }
        if (this._properties.containsKey(path + ".password")) {
            this._properties.remove(path + ".password");
        }
    }

    protected WikittyProxy createLocalProxy(Properties properties, String login, String password) {
        WikittyProxy proxy = new WikittyProxy();
        try {
            WikittyServiceJDBC ws = new WikittyServiceJDBC(properties);
            ws = new WikittyServiceCached((WikittyService)ws);
            proxy.setWikittyService((WikittyService)ws);
        }
        catch (Exception eee) {
            return null;
        }
        if (!login.isEmpty()) {
            proxy.login(login, password);
        }
        return proxy;
    }

    protected void goToWikittyPage(WikittyProxy proxy) {
        Sessions.getCurrent().setAttribute("proxy", (Object)proxy);
        Executions.sendRedirect((String)"wikitty.zul");
    }

    protected void fillDistantProxy(Data data) {
        ((Textbox)this.self.getFellow("distantName")).setValue(data.getName());
        ((Textbox)this.self.getFellow("distantURL")).setValue(data.getUrl());
        this.enableDistantUpdateButton();
    }

    protected void fillLocalProxy(Data data) {
        ((Textbox)this.self.getFellow("name")).setValue(data.getName());
        ((Textbox)this.self.getFellow("solr")).setValue(data.getSolr());
        ((Textbox)this.self.getFellow("db")).setValue(data.getDb());
        ((Combobox)this.self.getFellow("driver")).setValue(data.getDriver());
        this.enableLocalUpdateButton();
    }

    protected void clearAllLocalFields() {
        Textbox input = (Textbox)this.self.getFellow("name");
        input.setValue("");
        input = (Textbox)this.self.getFellow("solr");
        input.setValue("");
        input = (Textbox)this.self.getFellow("db");
        input.setValue("");
        input = (Textbox)this.self.getFellow("login");
        input.setValue("");
        input = (Textbox)this.self.getFellow("password");
        input.setValue("");
        Combobox box = (Combobox)this.self.getFellow("driver");
        box.setText(null);
    }

    protected void clearAllDistantFields() {
        Textbox input = (Textbox)this.self.getFellow("distantName");
        input.setValue("");
        input = (Textbox)this.self.getFellow("distantURL");
        input.setValue("");
        input = (Textbox)this.self.getFellow("distantLogin");
        input.setValue("");
        input = (Textbox)this.self.getFellow("distantPassword");
        input.setValue("");
    }

    public void onSelect$dataList() {
        Listitem item = this.dataList.getSelectedItem();
        if (item != null) {
            this.disableUpdateButtons();
            Data data = (Data)item.getValue();
            String login = data.getLogin();
            String password = data.getPassword();
            Groupbox box = (Groupbox)this.self.getFellow("loginPassword");
            if (box != null) {
                if (!password.isEmpty() && !login.isEmpty()) {
                    box.setVisible(true);
                    Textbox loginText = (Textbox)box.getFellow("selectLogin");
                    loginText.setValue("");
                    Textbox passwordText = (Textbox)box.getFellow("selectPassword");
                    passwordText.setValue("");
                } else {
                    box.setVisible(false);
                }
            }
            this.clearAllDistantFields();
            this.clearAllLocalFields();
        }
    }

    public void onClick$modify() {
        Listitem item = this.dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data)item.getValue();
            String url = data.getUrl();
            if (!url.isEmpty()) {
                this.fillDistantProxy(data);
            } else {
                this.fillLocalProxy(data);
            }
        }
    }

    public void onClick$update() throws IOException {
        Listitem item = this.dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data)item.getValue();
            String name = ((Textbox)this.self.getFellow("name")).getValue();
            String db = ((Textbox)this.self.getFellow("db")).getValue();
            String solr = ((Textbox)this.self.getFellow("solr")).getValue();
            Combobox box = (Combobox)this.self.getFellow("driver");
            String driver = "";
            Comboitem boit = box.getSelectedItem();
            if (boit != null) {
                driver = boit.getLabel();
            }
            if (!(name.isEmpty() || db.isEmpty() || solr.isEmpty() || driver.isEmpty())) {
                data.setAll(name, db, driver, solr, null, data.getLogin(), data.getPassword());
                this.saveUpdateData(data);
                this.disableUpdateButtons();
            }
        }
    }

    public void onClick$distantUpdate() throws IOException {
        Listitem item = this.dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data)item.getValue();
            String name = ((Textbox)this.self.getFellow("distantName")).getValue();
            String URL2 = ((Textbox)this.self.getFellow("distantURL")).getValue();
            if (!name.isEmpty() && !URL2.isEmpty()) {
                data.setAll(name, null, null, null, URL2, data.getLogin(), data.getPassword());
                this.saveUpdateData(data);
                this.disableUpdateButtons();
            }
        }
    }

    public void onClick$select() throws ArgumentsParserException {
        Listitem item = this.dataList.getSelectedItem();
        if (item != null) {
            Data data = (Data)item.getValue();
            String login = ((Textbox)this.self.getFellow("selectLogin")).getValue();
            String password = ((Textbox)this.self.getFellow("selectPassword")).getValue();
            if (!(!data.hasLoginPassword() || login.equals(data.getLogin()) && password.equals(password))) {
                return;
            }
            WikittyProxy proxy = null;
            if (data.getUrl().isEmpty()) {
                Properties properties = this.getLocalProperties(data);
                proxy = this.createLocalProxy(properties, login, password);
            }
            if (proxy != null) {
                this.goToWikittyPage(proxy);
            }
        }
    }

    public void onClick$add() throws FileNotFoundException, IOException {
        String name = ((Textbox)this.self.getFellow("name")).getValue();
        String db = ((Textbox)this.self.getFellow("db")).getValue();
        String solr = ((Textbox)this.self.getFellow("solr")).getValue();
        String login = ((Textbox)this.self.getFellow("login")).getValue();
        String password = ((Textbox)this.self.getFellow("password")).getValue();
        String driver = "";
        Combobox box = (Combobox)this.self.getFellow("driver");
        Comboitem item = box.getSelectedItem();
        if (item != null) {
            driver = item.getLabel();
        }
        if (!(name.isEmpty() || db.isEmpty() || solr.isEmpty() || driver.isEmpty())) {
            Data data = new Data(name, db, driver, solr, null, login, password);
            this.saveNewData(data);
        }
    }

    public void onClick$distantAdd() throws FileNotFoundException, IOException {
        String name = ((Textbox)this.self.getFellow("distantName")).getValue();
        String URL2 = ((Textbox)this.self.getFellow("distantURL")).getValue();
        String login = ((Textbox)this.self.getFellow("distantLogin")).getValue();
        String password = ((Textbox)this.self.getFellow("distantPassword")).getValue();
        if (!name.isEmpty() && !URL2.isEmpty()) {
            Data data = new Data(name, null, null, null, URL2, login, password);
            this.saveNewData(data);
        }
    }

    public void onClick$delete() throws IOException {
        Set set = this.dataList.getSelectedItems();
        ArrayList items = new ArrayList(set);
        if (items != null) {
            for (Listitem item : items) {
                Data data = (Data)item.getValue();
                this.removeDataFromProperties(data);
                this._proxyModel.removeData(data);
            }
            this.saveProperties();
            this.disableUpdateButtons();
        }
    }

    public ListitemRenderer getDataRenderer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ProxyModel getProxyModel() {
        return this._proxyModel;
    }

    public Properties getLocalProperties(Data data) throws ArgumentsParserException {
        ApplicationConfig config = new ApplicationConfig();
        config.parse(new String[0]);
        Properties properties = config.getFlatOptions();
        properties.setProperty("solr.data.dir", data.getSolr());
        properties.setProperty("jdbc.con.driver", data.getDriver());
        properties.setProperty("jdbc.con.host", data.getDb());
        properties.setProperty("jdbc.con.userName", "sa");
        properties.setProperty("jdbc.con.password", "");
        System.setProperty("solr.data.dir", data.getSolr());
        return properties;
    }
}

