/*
 * #%L
 * Wikitty :: struts
 * 
 * $Id: SelectFixedTag.java 1306 2012-01-09 13:24:33Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.3/wikitty-struts/src/main/java/org/nuiton/wikitty/struts/tag/SelectFixedTag.java $
 * %%
 * Copyright (C) 2011 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.struts.tag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.Component;
import org.nuiton.wikitty.struts.component.SelectFixedBean;
import com.opensymphony.xwork2.util.ValueStack;

public class SelectFixedTag extends AbstractWikittyTagComponent {

    /**
     * 
     */
    private static final long serialVersionUID = -8415432856577152486L;
    protected String fixvalues;

    @Override
    public Component getBean(ValueStack stack, HttpServletRequest req,
            HttpServletResponse res) {
        return new SelectFixedBean(stack, req, res);
    }

    @Override
    protected void populateParams() {
        super.populateParams();
        SelectFixedBean fieldtag = ((SelectFixedBean) component);

        fieldtag.setFixvalues(fixvalues);

    }

    public String getFixvalues() {
        return fixvalues;
    }

    public void setFixvalues(String fixvalues) {
        this.fixvalues = fixvalues;
    }

}
