/*
 * #%L
 * Wikitty :: publication
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.publication;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubDataImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyPublicationFileSystem implements WikittyService {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    final static private Log log = LogFactory
            .getLog(WikittyPublicationFileSystem.class);

    static public String WIKITTYLABEL_SEPARATOR = ".";

    protected File homeFile;

    /**
     * Constructor with the working directory
     * 
     * @param home
     *            the home directory
     */
    public WikittyPublicationFileSystem(File home) {
        this.setHomeFile(home);
    }

    public File getHomeFile() {
        return homeFile;
    }

    public void setHomeFile(File homeFile) {
        this.homeFile = homeFile;
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener,
            ServiceListenerType type) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        //

    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener,
            ServiceListenerType type) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        //

    }

    @Override
    public String login(String login, String password) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public void logout(String securityToken) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        //

    }

    @Override
    public WikittyEvent clear(String securityToken) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return false;

    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return false;

    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return false;

    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return false;

    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return false;

    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events,
            boolean force) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyEvent store(String securityToken,
            Collection<Wikitty> wikitties, boolean force) {

        // StringUtil.encodeMD5(toEncode)

        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken,
            String extensionName) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyEvent storeExtension(String securityToken,
            Collection<WikittyExtension> exts) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyEvent deleteExtension(String securityToken,
            Collection<String> extNames) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyExtension restoreExtension(String securityToken,
            String extensionId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken,
            String name) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> id) {
        // TODO mfortun-2011-04-05

        /*
         *  
         */

        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public List<PagedResult<String>> findAllByCriteria(String securityToken,
            List<Criteria> criteria) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public List<String> findByCriteria(String securityToken, List<Criteria> criteria) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public TreeNodeResult<String> findTreeNode(String securityToken,
            String wikittyId, int depth, boolean count, Criteria filter) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId,
            String version) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        // return null;

    }

    @Override
    public void syncSearchEngine(String securityToken) {
        // TODO mfortun-2011-04-05
        throw new UnsupportedOperationException("not yet implemented");
        //

    }

    /**
     * Transform an object into a wikitty object in this case a File into a
     * wikittyPubText/Data
     * 
     * @param fileToTransform
     *            the objet to transform
     * @param starts
     *            the home directory of the fileToTransform use to contruct the
     *            label
     * @return the wikitty
     * @throws Exception
     */
    /*
     * TODO mfortun-2011-04-07 correct the Exception's type
     */
    static public Wikitty fileToWikitty(File fileToTransform, File starts)
            throws Exception {

        String completeName = fileToTransform.getName();
        // isolate extension and file name

        String extension = FileUtil.extension(fileToTransform);
        String name = FileUtil.basename(completeName, "." + extension);
        // search for the mimetype
        String mimeType = mimeTypeForExtension(extension);

        // prepare wikitty basics
        Wikitty result = new WikittyImpl();
        result.addExtension(WikittyLabelImpl.extensionWikittyLabel);

    
        //creation of the label
        /*
         * TODO mfortun-2011-04-08 find a better way to do this ?
         */
        String pathToFile = fileToTransform.getParent();
        String pathToStart = starts.getCanonicalPath();
        String startDirName = starts.getName();

        /*
         * remove path from root to start dir to have path from start to current
         * working dir e.g.: if current file=
         * /home/foo/bob/chaine.chaussette.tar.gz and starts dir = /home/foo/
         * then path will be = foo/bob
         */
        String path = startDirName + pathToFile.replaceAll(pathToStart, "");

        String label = path.replaceAll(File.separator, WIKITTYLABEL_SEPARATOR);

        WikittyLabelHelper.addLabels(result, label);

   
        // complete with the correct extension with content
        if (isMimeWikittyPubText(mimeType)) {
            result.addExtension(WikittyPubTextImpl.extensionWikittyPubText);
            WikittyPubTextHelper.setName(result, name);
            WikittyPubTextHelper.setMimeType(result, mimeType);
            WikittyPubTextHelper.setContent(result,
                    FileUtil.readAsString(fileToTransform));
        } else {
            result.addExtension(WikittyPubDataImpl.extensionWikittyPubData);
            WikittyPubDataHelper.setName(result, name);
            WikittyPubDataHelper.setMimeType(result, mimeType);
            WikittyPubDataHelper.setContent(result,
                    FileUtil.fileToByte(fileToTransform));
        }

        return result;

    }

    /**
     * Return the mime type for an extension name Extension
     * 
     * @param ext
     * @return
     */
    static public String mimeTypeForExtension(String ext) {
        /*
         * TODO mfortun-2011-04-08 really implements this method
         * 
         */
        if (ext.equalsIgnoreCase("ws")) {
            return "application/javascript";
        } else {
            return "image/png";
        }

    }

    /**
     * return if the mime type is associate to a wikittypubtext
     * 
     * @param mime
     * @return
     */
    static public boolean isMimeWikittyPubText(String mime) {
        /*
         * TODO mfortun-2011-04-08 really implements this method
         * 
         */
        if (mime.equalsIgnoreCase("application/javascript")) {
            return true;
        } else {
            return false;
        }
    }

}
