/*
 * #%L
 * Wikitty :: publication
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.publication;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.publication.entities.WikittyPubData;
import org.nuiton.wikitty.publication.entities.WikittyPubText;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;


/**
 * Main class of the sync part of wikitty publication, this class is the entry
 * point for sync operation : import, checkout, commit, delete, relocate and
 * update.
 * 
 * 
 * 
 * @author mfortun
 * 
 */
public class WikittyPublication {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    final static private Log log = LogFactory.getLog(WikittyPublication.class);

    static protected ApplicationConfig applicationConfig;

    /*
     * static string for allias, wrong named attribut TODO mfortun-2011-04-06
     * need to set better name
     */
    static public String WITTY_SERVICE_KEY = "wikitty.service.server.url";
    static public String NO_RECURSION_KEY = "norecursion";
    static public String DIRECTORY_KEY = "directory";
    static public String HESSIAN_PROTOCOL_KEY = "hessian";

    static public String DEFAULT_PROPERTY_NAME_SEP = ".";

    static public String PROPERTY_DIRECTORY = ".wp";
    static public String WIKITTYPUBLICATION_PROPERTIES_FILE = "ws.properties";

    /*
     * Need a different file for id and meta information about wikittiesFiles
     * because with this solution we can simply read the ids with props.keySet()
     */
    static public String WIKITTY_ID_PROPERTIES_FILE = "ids.properties";
    static public String WIKITTY_FILE_META_PROPERTIES_FILE = "meta.properties";

    /*
     * in the WIKITTY_FILE_META_PROP ERTIES_FILE the keys for version are:
     * filename + META_SUFFIX_KEY_VERSION we save the id too because with this
     * solution un case of delete we can easily read the id and make operation
     * on the wikitty
     */
    static public String META_SUFFIX_KEY_VERSION = "version";
    static public String META_SUFFIX_KEY_CHECKSUM = "checksum";
    static public String META_SUFFIX_KEY_ID = "id";

    static public String META_CURRENT_LABEL = "current.label";
    static public String META_SUB_LABEL = "sub.label";

    /**
     * @param args
     * @throws ArgumentsParserException
     */
    static public void main(String[] args) throws Exception {

        /*
		 * 
		 */

        // on va creer un wikitty proxy pour le lien avec le wikitty qui stock
        // mes trucs
        // et on va avoir un wikittypublicationfilesystem pour stocker sur le
        // local et tout
        // soucis du wikittyFS c'est de savoir dans quel dossier il va taffer ?
        // a moins qu'il prenne un directory de travail

        /*
         * ws.properties :wikitty.service= http://www.adresse.com:8080
         * 
         * wikittypubs.properties script.js=numéroVersion7 id.script.js= id du
         * wikitty scripttut.js=numéroVersion id.scripttut.js= id du wikitty
         * image.png=numéroVersion id.image.png= id du wikitty label=
         * racine.directory2, racine.directory22
         */

        applicationConfig = new ApplicationConfig();

        // allias for the url of the wikitty service
        applicationConfig.addAlias("--ws", "--option", WITTY_SERVICE_KEY);

        applicationConfig.addAlias("--dir", "--option", DIRECTORY_KEY);

        /*
         * TODO mfortun-2011-04-05 once application fixed setdefault value and
         * enumclass for initialisation
         */

        // allias for norecursion
        applicationConfig.addAlias("--norecursion", "--option",
                NO_RECURSION_KEY, "true");

        // allias for the protocole
        applicationConfig.addAlias("--hessian", "--option",
                HESSIAN_PROTOCOL_KEY, "true");

        // allias for all the action
        applicationConfig.addAlias("wp import", "--option", "import");
        applicationConfig.addAlias("wp checkout", "--option", "checkout");
        applicationConfig.addAlias("wp relocate", "--option", "relocate");
        applicationConfig.addAlias("wp commit", "--option", "commit");
        applicationConfig.addAlias("wp delete", "--option", "delete");
        applicationConfig.addAlias("wp update", "--option", "update");

        applicationConfig
                .addActionAlias("import",
                        "org.nuiton.wikitty.publication.WikittyPublication#importToWikitty");

        applicationConfig
                .addActionAlias("checkout",
                        "org.nuiton.wikitty.publication.WikittyPublication#checkoutFromWikitty");

        applicationConfig
                .addActionAlias("relocate",
                        "org.nuiton.wikitty.publication.WikittyPublication#relocateWikitty");

        applicationConfig
                .addActionAlias("commit",
                        "org.nuiton.wikitty.publication.WikittyPublication#commitToWikitty");

        applicationConfig
                .addActionAlias("delete",
                        "org.nuiton.wikitty.publication.WikittyPublication#deleteFromWikitty");

        applicationConfig
                .addActionAlias("update",
                        "org.nuiton.wikitty.publication.WikittyPublication#updateFromWikitty");

        // parsing
        applicationConfig.parse(args);
        // execution
        applicationConfig.doAction(0);

    }

    /**
     * Method that import the content of a directory into a wikitty service
     */
    static public void importToWikitty() throws Exception {

        boolean noRecur = applicationConfig
                .getOptionAsBoolean(NO_RECURSION_KEY);
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);

        log.info("import : wikittyservice: " + wikittyService + " noresursion="
                + noRecur + " directory= " + dir.getAbsolutePath());
        // usage: wp --norecursion --ws http://truc.com import --dir /home/Manou

        applicationConfig.setOption("wikitty.WikittyService.components",
                "org.nuiton.wikitty.services.WikittyServiceCajoClient");

        System.out.println(applicationConfig
                .getOption("wikitty.service.server.url"));

        // real code:
        WikittyProxy remoteWikittyService = new WikittyProxy(
                WikittyServiceFactory.buildWikittyService(applicationConfig));

        // load the list of file
        List<File> toTransfert = listFile(dir, !noRecur);

        List<Wikitty> listWikitty = new ArrayList<Wikitty>();
        // transform file into wikitties

        for (File fileToTransform : toTransfert) {
            listWikitty.add(WikittyPublicationFileSystem.fileToWikitty(
                    fileToTransform, dir));
        }

        // send the wikitties
        remoteWikittyService.storeWikitty(listWikitty);

    }

    /*
     * TODO mfortun-2011-04-05 just prototyping, remove when really implements
     * the method linked: importToWikitty
     */
    static public void printDirectory(File dir, boolean recur) {

        System.out.println("<dir " + dir.getName() + ">");
        for (File child : dir.listFiles()) {
            if (child.isDirectory() && recur
                    && !child.getName().equals(PROPERTY_DIRECTORY)) {
                printDirectory(child, recur);
            } else if (!child.isDirectory()) {
                System.out.println(child.getAbsolutePath());
            }
        }
        System.out.println("</dir " + dir.getName() + ">");
    }

    /**
     * Method that create the list of file needed to commit, delete, update
     * import. It harvest file in order to transform them into wikitties
     * 
     * @param starts
     *            harvested directory
     * @param recursivly
     *            boolean id the directory have to be harvest
     * @return list of harvested file
     */
    static protected List<File> listFile(File starts, boolean recursivly) {
        ArrayList<File> result = new ArrayList<File>();
        if (!starts.isDirectory()) {
            result.add(starts);
        }
        for (File child : starts.listFiles()) {
            if (child.isDirectory() && recursivly
                    && !child.getName().equals(PROPERTY_DIRECTORY)) {
                // Directory don't have to be harvest
                // result.add(child);
                result.addAll(listFile(child, recursivly));
            } else if (!child.isDirectory()) {
                result.add(child);
            }
        }
        return result;
    }

    /**
     * Method that checkout a label recursivly or not into a local directory
     * from a wikitty service
     */
    static public void checkoutFromWikitty(String label) throws Exception {

        boolean noRecur = applicationConfig
                .getOptionAsBoolean(NO_RECURSION_KEY);
        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig
                .getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);

        log.info("checkout : wikittyservice: " + wikittyService
                + " noresursion=" + noRecur + " directory= "
                + dir.getAbsolutePath() + "Label a checkout " + label
                + "HessianProtocol=" + hessianProtocole);

        WikittyProxy remoteWikittyService = new WikittyProxy(
                WikittyServiceFactory.buildWikittyService(applicationConfig));
        WikittyPublicationFileSystem localWikittyService = new WikittyPublicationFileSystem(
                dir);

        // Construct the criteria
        Criteria labelCriteria;
        Search mainRequest = Search.query();
        Search subRoqu = mainRequest.or();

        // must have the type of wikittypubtext/wikittypubdata
        subRoqu.exteq(WikittyPubText.EXT_WIKITTYPUBTEXT).exteq(
                WikittyPubData.EXT_WIKITTYPUBDATA);
        if (noRecur) {
            // and extension with the name strictly equals to the label (no
            // recursivity)
            labelCriteria = mainRequest.exteq(WikittyLabel.EXT_WIKITTYLABEL)
                    .eq(WikittyLabel.FQ_FIELD_WIKITTYLABEL_LABELS, label)
                    .criteria();

        } else {
            // and extension with the name that containt the label (recursivity)
            labelCriteria = mainRequest.exteq(WikittyLabel.EXT_WIKITTYLABEL)
                    .sw(WikittyLabel.FQ_FIELD_WIKITTYLABEL_LABELS, label)
                    .criteria();
        }

        // request to the proxy
        List<Wikitty> wikittiesToWrite = remoteWikittyService
                .findAllByCriteria(labelCriteria).getAll();

        // write the wikities
        localWikittyService.store("", wikittiesToWrite, true);

        /*
         * obtain the list of wikittypub and write then in the file system with
         * the appropriate wikittyservice !
         */

        // write the proper properties file!
        Properties props = new Properties();
        props.put(WITTY_SERVICE_KEY, wikittyService);
        if (hessianProtocole) {
            props.put("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            props.put("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }

        // create the properties directory
        File wpDirectory = new File(dir.getCanonicalPath() + File.separator
                + PROPERTY_DIRECTORY + File.separator);
        if (!wpDirectory.exists()) {
            wpDirectory.createNewFile();
        }

        File propertiesFiles = new File(wpDirectory.getCanonicalPath()
                + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);

        props.store(new FileWriter(propertiesFiles), "");
        /*
         * on va commencer par vérifier les arguments ''wp checkout
         * [--norecursion] [url du WikittyService] [Label à extraire] [directory
         * local d'accueil]'' on doit avoir trois string dans le unparsed: url,
         * label, directory et potentiellement quelque chose dans le getoption
         * recursion
         */

    }

    /**
     * Relocate the default url of the wikitty service
     */
    static public void relocateWikitty() throws Exception {

        /*
         * log.info("checkout : wikittyservice: " + wikittyService +
         * " noresursion=" + noRecur + " directory= " + dir.getAbsolutePath()
         * +"Label a checkout " +label+ "HessianProtocol="+hessianProtocole);
         */

        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);
        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig
                .getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);

        File wpHomeDir;

        System.out
                .println("search the directory of .wp file to write new properties file");
        // search for the home directory
        if (null == dir || !dir.exists()) {
            wpHomeDir = searchWikittyPublicationHomeDir(new File("."));
        } else {
            wpHomeDir = new File(dir.getCanonicalFile() + File.separator
                    + PROPERTY_DIRECTORY);
        }

        Properties oldProperties = new Properties();

        // TODO mfortun-2011-04-06 catch exception instead of throws
        File propertiesFile = new File(wpHomeDir + File.separator
                + WIKITTYPUBLICATION_PROPERTIES_FILE);
        // load the old file just for loggin
        oldProperties.load(new FileReader(propertiesFile));

        log.info("Try relocate :" + "wikitty service:"
                + oldProperties.getProperty(WITTY_SERVICE_KEY) + " by "
                + wikittyService + " HessianProtocol: " + hessianProtocole
                + " File : " + propertiesFile.getCanonicalPath());

        // Creation of the new properties file
        Properties props = new Properties();
        props.put(WITTY_SERVICE_KEY, wikittyService);
        if (hessianProtocole) {
            props.put("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            props.put("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }

        // save the new property file
        props.store(new FileWriter(propertiesFile), "");

        /*
         * on va commencer par vérifier les arguments ''wp relocate [nouvelle
         * url du WikittyService par defaut] [directory a relocaliser]'' on doit
         * avoir trois string dans le unparsed: url et directory
         */

    }

    /**
     * commit the current wikittyworkspace into a wikitty service
     */
    static public void commitToWikitty() throws Exception {

        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);

        File wpHomeDir;
        if (null == dir || !dir.exists()) {
            /*
             * si pas de dir on commit le dossier courant
             */
            dir = new File(".");

        }
        // on va chercher le home dir
        wpHomeDir = searchWikittyPublicationHomeDir(dir);

        Properties properties = new Properties();

        // TODO mfortun-2011-04-06 catch exception instead of throws
        File propertiesFile = new File(wpHomeDir.getCanonicalPath()
                + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        // load the old file just for loggin
        properties.load(new FileReader(propertiesFile));

        // on va rajouter les propriété de notre file
        applicationConfig.setOptions(properties);

        boolean noRecur = applicationConfig
                .getOptionAsBoolean(NO_RECURSION_KEY);

        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig
                .getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);

        if (hessianProtocole) {
            applicationConfig.setOption("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            applicationConfig.setOption("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }

        log.info("commit " + " wikitty-service" + wikittyService
                + "noRecurs : " + noRecur + " hessian Protocole :"
                + hessianProtocole + "directory : " + dir.getAbsolutePath());

        System.out.println("try to commit: ");
        printDirectory(dir, !noRecur);

        // faire la liste des fichiers à commit
        // avec récursivité si c'etransfert d'histoire entre svnst demandé.
        // et les transformer en wikitty, vérifier les versions et tout.

        /*
         * parcours l'arborescence des fichiers celon que on soit recursif ou
         * non plutot que faire la liste fichier, on va aller lire les ids dans
         * les fichiers de propriétés.
         * 
         * Ensuite on creer le wikittyserviceFileSysteme avec le répertoire de
         * travail et lui on lui donner les ids avec lesquels il va travailler
         * et aller chercher les fichiers de propriétés pour retrouver les files
         * et creer les wikittypub correspondant.
         * 
         * Pour faire un commit il ne suffira pas de faire un restore
         * finalement, il faudra faire un search aussi puisque on va se
         * retrouver à faire des new wikitty p'etre éclaircir ce point plus
         * tard. Pour le moment ne pas se poser de question trop, et faire sans
         * nouveau fichier.
         */

        // création du proxy

        /*
         * on va commencer par vérifier les arguments ''wp commit
         * [--norecursion] [--ws (url du WikittyService)] [répertoire à
         * pousser]'' on doit avoir deux string dans le unparsed et
         * potentiellement quelque chose dans le getoption recursion
         */

    }

    /**
     * delete a file or directory from the workspace it remove the label from
     * the wikitty
     * 
     * @throws Exception
     */
    static public void deleteFromWikitty(File toDelete) throws Exception {

        // check args
        if (null == toDelete || !toDelete.exists()) {
            // Exception
        } else {

            File wpHomeDir = searchWikittyPublicationHomeDir(new File("."));
            // search for the .wp home dir to load props

            // then load proxy

            // if toDelete is a directory do something different from usualy
            // recursivly remove labels

            File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);

            // on va chercher le home dir
            wpHomeDir = searchWikittyPublicationHomeDir(dir);

            Properties properties = new Properties();

            // TODO mfortun-2011-04-06 catch exception instead of throws
            File propertiesFile = new File(wpHomeDir.getCanonicalPath()
                    + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
            // load the old file just for loggin
            properties.load(new FileReader(propertiesFile));

            // on va rajouter les propriété de notre file
            applicationConfig.setOptions(properties);

            String wikittyService = applicationConfig
                    .getOption(WITTY_SERVICE_KEY);
            boolean hessianProtocole = applicationConfig
                    .getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);

            if (hessianProtocole) {
                applicationConfig
                        .setOption("wikitty.WikittyService.components",
                                "org.nuiton.wikitty.services.WikittyServiceHessianClient");
            } else {
                applicationConfig.setOption(
                        "wikitty.WikittyService.components",
                        "org.nuiton.wikitty.services.WikittyServiceCajoClient");
            }

            log.info("Delete " + " wikitty-service" + wikittyService
                    + " hessian Protocole :" + hessianProtocole
                    + "file to delete : " + toDelete.getAbsolutePath());

            System.out.println("try to delete: ");
            printDirectory(dir, true);

        }

        /*
         * on va commencer par vérifier les arguments ''wp delete [--ws (url du
         * WikittyService)] [répertoire ou fichier à supprimer]'' on doit avoir
         * un string dans le unparsed et après pour pour le wikittyservice bah
         * on tape dedans en fonction de si elle a été précisé en ligne de
         * commande applicationConfig se débrouille
         */
    }

    /**
     * update the current workspace from a wikitty
     */
    static public void updateFromWikitty() throws Exception {

        File dir = applicationConfig.getOptionAsFile(DIRECTORY_KEY);

        File wpHomeDir;
        if (null == dir || !dir.exists()) {
            /*
             * si pas de dir on update le dossier courant
             */
            dir = new File(".");

        }
        // on va chercher le home dir
        wpHomeDir = searchWikittyPublicationHomeDir(dir);

        Properties properties = new Properties();

        // TODO mfortun-2011-04-06 catch exception instead of throws
        File propertiesFile = new File(wpHomeDir.getCanonicalPath()
                + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
        // load the old file just for loggin
        properties.load(new FileReader(propertiesFile));

        // on va rajouter les propriété de notre file
        applicationConfig.setOptions(properties);

        boolean noRecur = applicationConfig
                .getOptionAsBoolean(NO_RECURSION_KEY);

        String wikittyService = applicationConfig.getOption(WITTY_SERVICE_KEY);
        boolean hessianProtocole = applicationConfig
                .getOptionAsBoolean(HESSIAN_PROTOCOL_KEY);

        if (hessianProtocole) {
            applicationConfig.setOption("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceHessianClient");
        } else {
            applicationConfig.setOption("wikitty.WikittyService.components",
                    "org.nuiton.wikitty.services.WikittyServiceCajoClient");
        }

        log.info("update " + " wikitty-service" + wikittyService
                + "noRecurs : " + noRecur + " hessian Protocole :"
                + hessianProtocole + "directory : " + dir.getAbsolutePath());

        System.out.println("try to update: ");
        printDirectory(dir, !noRecur);

        /*
         * on va commencer par vérifier les arguments * ''wp update
         * [--norecursion] [--ws (url du WikittyService)] [répertoire à mettre à
         * jour]'' normalement un string dans unparsed et potentiellement
         * quelque chose dans le recursion
         */
    }

    /**
     * 
     * Use to search in the file system the directory that containt the .wp dir
     * that containt the properties file for the wikitty service's adresse
     * 
     * @param start
     * @return File the directory container of the master property file
     * @throws Exception
     */
    static protected File searchWikittyPublicationHomeDir(File start)
            throws Exception {

        if (start != null && start.exists() && start.isDirectory()) {
            // on va retourner le dossier .wp home

            // method récursiv qui remonte dans les parents pour retrouver.

            File propertyDirectory = new File(start.getCanonicalPath()
                    + File.separator + PROPERTY_DIRECTORY);
            if (propertyDirectory.exists()) {
                File propertie = new File(propertyDirectory.getCanonicalPath()
                        + File.separator + WIKITTYPUBLICATION_PROPERTIES_FILE);
                if (propertie.exists()) {
                    return propertyDirectory;
                }
            }
            return searchWikittyPublicationHomeDir(start.getParentFile());
        } else {
            // Exception
            /*
             * TODO mfortun-2011-04-06 write/set the appropriate exception here
             */
            return null;
        }
    }

    static protected HashMap<String, String> deleteFile(File toDelete)
            throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();

        String pathToProperty = toDelete.getCanonicalFile() + File.separator
                + PROPERTY_DIRECTORY + File.separator;
        // load properties files
        File metaFile = new File(pathToProperty
                + WIKITTY_FILE_META_PROPERTIES_FILE);
        Properties metaProperties = new Properties();
        metaProperties.load(new FileReader(metaFile));

        File idFile = new File(pathToProperty + WIKITTY_ID_PROPERTIES_FILE);
        Properties idProperties = new Properties();
        idProperties.load(new FileReader(idFile));

        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                if (child.isDirectory()
                        && !child.getName().equals(PROPERTY_DIRECTORY)) {
                    result.putAll(deleteFile(child));
                }
            }
            // remove label from current label list
            /*
             * TODO mfortun-2011-04-07 it's ugly change this, if we keep the
             * property linked
             */
            String[] currents = StringUtil.split(
                    metaProperties.getProperty(META_SUB_LABEL), ",");
            ArrayList<String> subLabel = new ArrayList<String>();
            for (String sub : currents) {
                if (!sub.endsWith(toDelete.getName())) {
                    subLabel.add(sub);
                }
            }
            String subLabelResult = StringUtil.join(subLabel, ",", true);
            metaProperties.put(META_SUB_LABEL, subLabelResult);

        } else {

            String id = metaProperties.getProperty(toDelete.getName()
                    + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_ID);
            String label = metaProperties.getProperty(META_CURRENT_LABEL);

            result.put(id, label);
            // remove from properties
            idProperties.remove(id);

            metaProperties.remove(toDelete.getName()
                    + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_ID);
            metaProperties.remove(toDelete.getName()
                    + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_CHECKSUM);
            metaProperties.remove(toDelete.getName()
                    + DEFAULT_PROPERTY_NAME_SEP + META_SUFFIX_KEY_VERSION);
        }

        metaProperties.store(new FileWriter(metaFile), "");
        idProperties.store(new FileWriter(idFile), "");

        toDelete.delete();
        return result;

    }

}
