/*
 * #%L
 * Wikitty :: dto
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;


public  class WikittyAuthorisationDTO implements WikittyAuthorisation {


@WikittyField(fqn="WikittyAuthorisation.owner")    protected String owner;

@WikittyField(fqn="WikittyAuthorisation.admin")    protected Set<String> admin = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyAuthorisation.writer")    protected Set<String> writer = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyAuthorisation.reader")    protected Set<String> reader = new LinkedHashSet<String>();

@WikittyField(fqn="WikittyAuthorisation.parent")    protected String parent;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getOwner :
     * @return String 
     */

    @Override
    public String getOwner() {
        return owner;
}

    /**
     * setOwner :
     * @param owner 
     */

    @Override
    public void setOwner(String owner) {
        this.owner=owner;
        modificationCount++;
}

    /**
     * getAdmin :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAdmin() {
        return admin;
}

    /**
     * setAdmin :
     * @param admin 
     */

    @Override
    public void setAdmin(Set<String> admin) {
        if (admin == null){
            this.admin = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.admin=new LinkedHashSet<String>(admin);
        }
        modificationCount++;
}

    /**
     * addAllAdmin :
     * @param admin 
     */

    @Override
    public void addAllAdmin(Set<String> admin) {
        if (this.admin == null){
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.addAll(admin);
        modificationCount++;
}

    /**
     * addAdmin :
     * @param element 
     */

    @Override
    public void addAdmin(String element) {
        if (this.admin == null){
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.add(element);
        modificationCount++;
}

    /**
     * removeAdmin :
     * @param element 
     */

    @Override
    public void removeAdmin(String element) {
        admin.remove(element);
        modificationCount++;
}

    /**
     * clearAdmin :
     */

    @Override
    public void clearAdmin() {
        admin.clear();
        modificationCount++;
}

    /**
     * getWriter :
     * @return Set<String> 
     */

    @Override
    public Set<String> getWriter() {
        return writer;
}

    /**
     * setWriter :
     * @param writer 
     */

    @Override
    public void setWriter(Set<String> writer) {
        if (writer == null){
            this.writer = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.writer=new LinkedHashSet<String>(writer);
        }
        modificationCount++;
}

    /**
     * addAllWriter :
     * @param writer 
     */

    @Override
    public void addAllWriter(Set<String> writer) {
        if (this.writer == null){
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.addAll(writer);
        modificationCount++;
}

    /**
     * addWriter :
     * @param element 
     */

    @Override
    public void addWriter(String element) {
        if (this.writer == null){
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.add(element);
        modificationCount++;
}

    /**
     * removeWriter :
     * @param element 
     */

    @Override
    public void removeWriter(String element) {
        writer.remove(element);
        modificationCount++;
}

    /**
     * clearWriter :
     */

    @Override
    public void clearWriter() {
        writer.clear();
        modificationCount++;
}

    /**
     * getReader :
     * @return Set<String> 
     */

    @Override
    public Set<String> getReader() {
        return reader;
}

    /**
     * setReader :
     * @param reader 
     */

    @Override
    public void setReader(Set<String> reader) {
        if (reader == null){
            this.reader = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.reader=new LinkedHashSet<String>(reader);
        }
        modificationCount++;
}

    /**
     * addAllReader :
     * @param reader 
     */

    @Override
    public void addAllReader(Set<String> reader) {
        if (this.reader == null){
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.addAll(reader);
        modificationCount++;
}

    /**
     * addReader :
     * @param element 
     */

    @Override
    public void addReader(String element) {
        if (this.reader == null){
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.add(element);
        modificationCount++;
}

    /**
     * removeReader :
     * @param element 
     */

    @Override
    public void removeReader(String element) {
        reader.remove(element);
        modificationCount++;
}

    /**
     * clearReader :
     */

    @Override
    public void clearReader() {
        reader.clear();
        modificationCount++;
}

    /**
     * getParent :
     * @return String 
     */

    @Override
    public String getParent() {
        return parent;
}

    /**
     * setParent :
     * @param parent 
     */

    @Override
    public void setParent(String parent) {
        this.parent=parent;
        modificationCount++;
}

    /**
     * WikittyAuthorisationDTO :
     */

    public WikittyAuthorisationDTO() {
}

    /**
     * WikittyAuthorisationDTO :
     * @param wikittyId 
     */

    public WikittyAuthorisationDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyAuthorisation)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyAuthorisation sourceCopy = (WikittyAuthorisation)source;

        setOwner(sourceCopy.getOwner());

        Set<String> admin = sourceCopy.getAdmin();
        if (admin != null){
            setAdmin(new LinkedHashSet<String>(admin));
        }

        Set<String> writer = sourceCopy.getWriter();
        if (writer != null){
            setWriter(new LinkedHashSet<String>(writer));
        }

        Set<String> reader = sourceCopy.getReader();
        if (reader != null){
            setReader(new LinkedHashSet<String>(reader));
        }

        setParent(sourceCopy.getParent());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //WikittyAuthorisationDTO
