/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.conditions;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ContainerOperator;

public abstract class ContainerNaryOperator
extends ContainerOperator {
    private static final long serialVersionUID = 1L;
    protected List<Condition> conditions;

    public ContainerNaryOperator() {
    }

    public ContainerNaryOperator(List<Condition> c) {
        this.conditions = new LinkedList<Condition>(c);
    }

    @Override
    public boolean waitCondition() {
        return true;
    }

    @Override
    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk && this.conditions != null) {
            boolean notFirst = false;
            for (Condition r : this.conditions) {
                if (notFirst) {
                    walk = visitor.visitMiddle(this);
                    if (!walk) {
                        break;
                    }
                } else {
                    notFirst = true;
                }
                r.accept(visitor);
            }
        }
        visitor.visitLeave(this, walk);
    }

    @Override
    boolean equalsDeep(Object other) {
        ContainerNaryOperator op = (ContainerNaryOperator)other;
        boolean result = ObjectUtils.equals(this.getConditions(), op.getConditions());
        return result;
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            this.conditions = new LinkedList<Condition>();
        }
        return this.conditions;
    }

    @Override
    public Condition addCondition(Condition c) {
        if (c != null) {
            if (c instanceof ConditionValue) {
                throw new WikittyException(String.format("Condition (%s) can't have condition '%s' as child", this.getClass().getSimpleName(), ClassUtils.getShortCanonicalName((Object)c, (String)"null")));
            }
            this.getConditions().add(c);
        }
        return this;
    }
}

