/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyLabelAbstract extends BusinessEntityImpl implements WikittyLabel {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyLabel;
    /**
     * getLabels :
     * @return Set<String> 
     */

    @Override
    public Set<String> getLabels() {
        Set<String> result = WikittyLabelHelper.getLabels(getWikitty());
        return result;
}

    /**
     * setLabels :
     * @param labels 
     */

    @Override
    public void setLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.setLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addAllLabels :
     * @param labels 
     */

    @Override
    public void addAllLabels(Set<String> labels) {
        Set<String> oldValue = getLabels();
        WikittyLabelHelper.addAllLabels(getWikitty(), labels);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, oldValue, getLabels());
}

    /**
     * addLabels :
     * @param element 
     */

    @Override
    public void addLabels(String element) {
        WikittyLabelHelper.addLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * removeLabels :
     * @param element 
     */

    @Override
    public void removeLabels(String element) {
        WikittyLabelHelper.removeLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * clearLabels :
     */

    @Override
    public void clearLabels() {
        WikittyLabelHelper.clearLabels(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyLabel.FIELD_WIKITTYLABEL_LABELS, null, getLabels());
}

    /**
     * WikittyLabelAbstract :
     */

    public WikittyLabelAbstract() {
        super();
}

    /**
     * WikittyLabelAbstract :
     * @param wikitty 
     */

    public WikittyLabelAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyLabelAbstract :
     * @param businessEntityImpl 
     */

    public WikittyLabelAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyLabel =
                new WikittyExtension(EXT_WIKITTYLABEL,
                                     "1.0", // version
                                     (List)null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String labels[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyLabel);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyLabelAbstract
