/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public interface WikittyHook extends BusinessEntity {     String EXT_WIKITTYHOOK = "WikittyHook";
     String FIELD_WIKITTYHOOK_NAME = "name";
     String FQ_FIELD_WIKITTYHOOK_NAME = EXT_WIKITTYHOOK + ".name";
     String FIELD_WIKITTYHOOK_ACTIONTOHOOK = "actionToHook";
     String FQ_FIELD_WIKITTYHOOK_ACTIONTOHOOK = EXT_WIKITTYHOOK + ".actionToHook";
     String FIELD_WIKITTYHOOK_SCRIPT = "script";
     String FQ_FIELD_WIKITTYHOOK_SCRIPT = EXT_WIKITTYHOOK + ".script";
     String FIELD_WIKITTYHOOK_MIMETYPE = "mimetype";
     String FQ_FIELD_WIKITTYHOOK_MIMETYPE = EXT_WIKITTYHOOK + ".mimetype";
    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setName :
     * @param name 
     */

     void setName(String name);

    /**
     * getActionToHook :
     * @return Set<String> 
     */

     Set<String> getActionToHook();

    /**
     * setActionToHook :
     * @param actionToHook 
     */

     void setActionToHook(Set<String> actionToHook);

    /**
     * addAllActionToHook :
     * @param actionToHook 
     */

     void addAllActionToHook(Set<String> actionToHook);

    /**
     * addActionToHook :
     * @param element 
     */

     void addActionToHook(String element);

    /**
     * removeActionToHook :
     * @param element 
     */

     void removeActionToHook(String element);

    /**
     * clearActionToHook :
     */

     void clearActionToHook();

    /**
     * getScript :
     * @return String 
     */

     String getScript();

    /**
     * setScript :
     * @param script 
     */

     void setScript(String script);

    /**
     * getMimetype :
     * @return String 
     */

     String getMimetype();

    /**
     * setMimetype :
     * @param mimetype 
     */

     void setMimetype(String mimetype);


} //WikittyHook
