/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: ExtensionFactoryTest.java 461 2010-10-29 15:19:55Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.1/wikitty-api/src/test/java/org/nuiton/wikitty/api/ExtensionFactoryTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.api;

import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.entities.WikittyExtension;

public class ExtensionFactoryTest extends AbstractTestApi {
    
    @Test
    public void testExtensionFactory() throws Exception {
        WikittyExtension ext = ExtensionFactory.create("testExtension", "1.0")
            .addField("name", TYPE.STRING)
                .notNull()
            .addField("phoneNumbers", TYPE.STRING)
                .minOccur(2)
                .maxOccur(10)
            .addField("matricule", TYPE.NUMERIC)
                .unique()
            .addField("fired", TYPE.BOOLEAN)
            .extension();
        
        Assert.assertEquals("testExtension", ext.getName());
        Assert.assertEquals("1.0", ext.getVersion());
        checkField( ext, "name", TYPE.STRING, 0, 1, false, true);
        checkField( ext, "phoneNumbers", TYPE.STRING, 2, 10, false, false);
        checkField( ext, "matricule", TYPE.NUMERIC, 0, 1, true, false);
        checkField( ext, "fired", TYPE.BOOLEAN, 0, 1, false, false);
        
    }
    
    private void checkField( WikittyExtension ext, String fieldName, TYPE type,
            int min, int max, boolean unique, boolean notNull) {
        FieldType fieldType = ext.getFieldType(fieldName);
        String str = "Checking " + ext.getName() + "." + fieldName + " field...";
        Assert.assertNotNull(str, fieldType );
        Assert.assertEquals(str, type, fieldType.getType());
        Assert.assertEquals(str, min, fieldType.getLowerBound());
        Assert.assertEquals(str, max, fieldType.getUpperBound());
        Assert.assertEquals(str, unique, fieldType.isUnique());
        Assert.assertEquals(str, notNull, fieldType.isNotNull());
    }
    

}
