/*
 * Copyright (c) 2010 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.nuiton.wikitty.importexport;

import java.io.Reader;
import java.io.Writer;

import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;

/**
 * Import / export interface.
 * 
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface ImportExportMethod {
    
    /**
     * Import data from reader.
     * 
     * @param securityToken security token
     * @param reader reader
     * @param ws wikitty service
     * @param transaction current transaction
     * @param batchUpdate wikitty batch update helper
     * 
     * @throws Exception
     */
    public void importReader(String securityToken, Reader reader,
            WikittyService ws, WikittyTransaction transaction,
            WikittyBatchUpdate batchUpdate) throws Exception;
    
    /**
     * Export data to writer.
     * 
     * @param securityToken security token
     * @param writer writer
     * @param ws wikitty service
     * @param transaction current transaction
     * @param pagedResult paged result
     * 
     * @throws Exception
     */
    public void exportWriter(String securityToken, Writer writer,
            WikittyService ws, WikittyTransaction transaction,
            PagedResult<Wikitty> pagedResult) throws Exception;
}
