package org.nuiton.wikitty;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface Wikitty extends Cloneable, Serializable {

    void addPropertyChangeListener(PropertyChangeListener listener);

    void removePropertyChangeListener(PropertyChangeListener listener);

    void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    String getId();

    boolean isDeleted();

    Date getDeleteDate();

    /**
     * Server only used
     * @param delete
     */
    void setDeleteDate(Date delete);

    void addExtension(WikittyExtension ext);

    void addExtension(List<WikittyExtension> exts);

    /**
     * check that the wikitty has a metaExtension about a given extension
     * @param metaExtension the metaExtension to be checked 
     * @param extension an extension already added to the wikitty
     * @since 2.2.0
     */
    boolean hasMetaExtension(String metaExtensionName,
                             String extensionName);

    /**
     * add a meta-extension about the given extension to this wikitty
     * @param metaExtension the metaExtension to add
     * @param extension an extension already added to the wikitty
     * @since 2.1
     */
    void addMetaExtension(WikittyExtension metaExtension,
                          WikittyExtension extension);
    

    /**
     * add a meta-extension on the given extension to this wikitty
     * @param metaExtension the metaExtension to add
     * @param extensionFqn the name of the extension already added to the wikitty
     * @since 2.1
     */
    void addMetaExtension(WikittyExtension metaExtension, String extensionFqn);

    boolean hasExtension(String extName);

    boolean hasField(String extName, String fieldName);

    WikittyExtension getExtension(String ext);

    Collection<String> getExtensionNames();

    Collection<WikittyExtension> getExtensions();

    Collection<WikittyExtension> getExtensionDependencies(String ext,
            boolean recursively);

    /**
     * return field type for the given fieldName.
     * @param fqfieldName fully qualified fieldName extension.fieldname
     * @return field type
     */
    FieldType getFieldType(String fqfieldName);

    void setField(String ext, String fieldName, Object value);

    Object getFieldAsObject(String ext, String fieldName);

    boolean getFieldAsBoolean(String ext, String fieldName);

    BigDecimal getFieldAsBigDecimal(String ext, String fieldName);

    int getFieldAsInt(String ext, String fieldName);

    long getFieldAsLong(String ext, String fieldName);

    float getFieldAsFloat(String ext, String fieldName);

    double getFieldAsDouble(String ext, String fieldName);

    String getFieldAsString(String ext, String fieldName);

    Date getFieldAsDate(String ext, String fieldName);

    /**
     * return wikitty id and not wikitty objet because this method can be call
     * on server or client side and it's better to keep conversion between id
     * and objet to the caller
     * @param ext extension name where this field must to be
     * @param fieldName the field name
     * @return id of wikitty object or null
     * @throws org.nuiton.wikitty.WikittyException
     */
    String getFieldAsWikitty(String ext, String fieldName);

    /**
     * If object is a set, it is automatically transform to list.
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> List<E> getFieldAsList(String ext, String fieldName,
            final Class<E> clazz);

    /**
     *
     * @param <E>
     * @param clazz
     * @return unmodifiable list
     */
    <E> Set<E> getFieldAsSet(String ext, String fieldName, final Class<E> clazz);

    void addToField(String ext, String fieldName, Object value);

    void removeFromField(String ext, String fieldName, Object value);

    void clearField(String ext, String fieldName);

    /**
     * Add an element in a field
     * @param fqFieldName the fully qualified name of a collection field
     * @param value the value to be added to the collection
     * @since 2.2.0
     */
    void addToField(String fqFieldName, Object value);

    /**
     * Remove an element from a field
     * @param fqFieldName the fully qualified name of a collection field
     * @param value the value to be removed to the collection
     * @since 2.2.0
     */
    void removeFromField(String fqFieldName, Object value);

    /**
     * Clear a field
     * @param fqFieldName the fully qualified name of a collection field
     * @since 2.2.0
     */
    void clearField(String fqFieldName);

    Set<String> fieldNames();

    Object getFqField(String fqFieldName);

    String getVersion();

    /**
     * Server only used
     * @param version
     */
    void setVersion(String version);

    /**
     * get the field modified after wikitty was restored
     * @return a set of fully qualified field names
     * @since 2.2.0
     */
    Set<String> getDirty();
    
    /**
     * Server only used
     * @param version
     */
    void clearDirty();


    /**
     * Server only used
     * @param fieldName fqn (ex: extensionName.fieldName)
     * @param value new value
     */
    void setFqField(String fieldName, Object value);

    boolean isEmpty();
    
    Wikitty clone() throws CloneNotSupportedException;



}