package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class LabelHelper {

    /**
     * LabelHelper :
     * utility class all provided methods are accessible the static way
     */

    private LabelHelper() {// empty
}

    /**
     * getLabels :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getLabels(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS, String.class);
        return result;
}

    /**
     * addLabels :
     * @param wikitty 
     * @param element 
     */

    public static void addLabels(Wikitty wikitty, String element) {
        wikitty.addToField(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS, element);
}

    /**
     * removeLabels :
     * @param wikitty 
     * @param element 
     */

    public static void removeLabels(Wikitty wikitty, String element) {
        wikitty.removeFromField(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS, element);
}

    /**
     * clearLabels :
     * @param wikitty 
     */

    public static void clearLabels(Wikitty wikitty) {
        wikitty.clearField(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS);
            Object f2 = w2.getFieldAsObject(Label.EXT_LABEL, Label.FIELD_LABEL_LABELS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Label.EXT_LABEL);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : LabelAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //LabelHelper
