package org.nuiton.web;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;

public class SecurityDAOHelper {

    public enum SecurityEntityEnum implements TopiaEntityEnum {
        SecurityRole(SecurityRole.class, ArrayUtils.EMPTY_STRING_ARRAY),
        SecurityUser(SecurityUser.class, ArrayUtils.EMPTY_STRING_ARRAY);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        SecurityEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds)     {
        this.contract = contract;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
        return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
        return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
        return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return SecurityDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static SecurityEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static SecurityEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (SecurityEntityEnum entityEnum : SecurityEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(SecurityEntityEnum.values()));
        }

    } //SecurityEntityEnum

    protected SecurityDAOHelper() { }

    public static String getModelVersion() {
        return "";
    }

    public static String getModelName() {
        return "Security";
    }

    public static SecurityRoleDAO getSecurityRoleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SecurityRoleDAO result = ci.getDAO(SecurityRole.class, SecurityRoleDAO.class);
        return result;
    }

    public static SecurityUserDAO getSecurityUserDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SecurityUserDAO result = ci.getDAO(SecurityUser.class, SecurityUserDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SecurityEntityEnum constant = SecurityEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SecurityEntityEnum[] values = SecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SecurityEntityEnum[] values = SecurityEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static SecurityEntityEnum[] getContracts() {
        return SecurityEntityEnum.values();
    }

} //SecurityDAOHelper
