/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.collect.Maps;
import java.sql.Blob;
import java.util.Map;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.tagvalue.TagValueAble;
import org.nuiton.eugene.models.tagvalue.TagValueDefinition;
import org.nuiton.eugene.models.tagvalue.TagValueDefinitionProvider;
import org.nuiton.eugene.models.tagvalue.TagValues;
import org.nuiton.eugene.models.tagvalue.matcher.StartsWithTagNameMatcher;

public class TopiaTagValues
extends TagValueDefinitionProvider {
    protected static final TopiaTagValues INSTANCE = new TopiaTagValues();
    @TagValueDefinition(target={ObjectModelClassifier.class}, documentation="TODO")
    public static final String TAG_PERSISTENCE_TYPE = "persistenceType";
    @TagValueDefinition(target={ObjectModelPackage.class, ObjectModelClassifier.class}, documentation="TODO")
    public static final String TAG_CONTEXTABLE = "contextable";
    @TagValueDefinition(target={ObjectModelElement.class}, documentation="Sets the database name of an element of the model (a table or a column)")
    public static final String TAG_DB_NAME = "dbName";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the database name of the reverse db name attribute of the model (a column)")
    public static final String TAG_REVERSE_DB_NAME = "reverseDbName";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the database table name of a many to many relation for a attribute of the model")
    public static final String TAG_MANY_TO_MANY_TABLE_NAME = "manyToManyTableName";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class}, documentation="Sets the database schema name")
    public static final String TAG_SCHEMA_NAME = "dbSchema";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the length of an attribute in database")
    public static final String TAG_LENGTH = "length";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets an annotation of an attribute")
    public static final String TAG_ANNOTATION = "annotation";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the access type of an attribute (Hibernate mapping)")
    public static final String TAG_ACCESS = "access";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets an attribute as part of a natural id (Hibernate Mapping)")
    public static final String TAG_NATURAL_ID = "naturalId";
    @TagValueDefinition(target={ObjectModelClassifier.class}, documentation="Sets if natural id of a entity is mutable (hibernate mapping)")
    public static final String TAG_NATURAL_ID_MUTABLE = "naturalIdMutable";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets which part of a N-N relation is master (inverse=true) and slave (inverse=false) (must be put on each side on a such relation) (Hibernate mapping)")
    public static final String TAG_INVERSE = "inverse";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets if an association should be lazy (Hibernate mapping)")
    public static final String TAG_LAZY = "lazy";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the fetch caracteristic of an attribute (Hibernate mapping)")
    public static final String TAG_FETCH = "fetch";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the order by propertie of an multiple association (Hibernate mapping)")
    public static final String TAG_ORDER_BY = "orderBy";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets if an attribute must be not null (Hibernate mapping)")
    public static final String TAG_NOT_NULL = "notNull";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModelAttribute.class}, documentation="'true' if the value of this attribute of type Enumeration should be stored with its name (instead of using ordinal)", defaultValue="true")
    public static final String TAG_USE_ENUMERATION_NAME = "useEnumerationName";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}, documentation="Configure the proxy interface on something else than the default implementation (null to use our default implementation, none to let hibernate deal it) (Hibernate mapping)")
    public static final String TAG_PROXY_INTERFACE = "hibernateProxyInterface";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}, documentation="Configure the proxy interface on something else than the default implementation (null to use our default implementation, none to let hibernate deal it) (Hibernate mapping)", defaultValue="union-subclass")
    public static final String TAG_INHERITANCE_STRATEGY = "inheritanceStrategy";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}, defaultValue="true", documentation="Tag to skip toString() methods generation on entities.")
    public static final String TAG_NOT_GENERATE_TO_STRING = "notGenerateToString";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}, documentation="To sort attribute while generation")
    public static final String TAG_SORT_ATTRIBUTE = "sortAttribute";
    @TagValueDefinition(target={ObjectModel.class}, documentation="To generate EntityOperation on generated DAOHelper")
    public static final String TAG_GENERATE_OPERATOR_FOR_DAO_HELPER = "generateOperatorForDAOHelper";
    @Deprecated
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the hibernate type of an attribute (Hibernate mapping)")
    public static final String TAG_TYPE = "type";
    @TagValueDefinition(target={ObjectModelAttribute.class}, documentation="Sets the sql type of an attribute (Hibernate mapping)")
    public static final String TAG_SQL_TYPE = "sqlType";
    @TagValueDefinition(target={ObjectModel.class}, documentation="Sets the fully qualified name of the DAO implementation to use in generated DAO (default is DAOImpl (base on TopiaQuery))")
    public static final String TAG_DAO_IMPLEMENTATION = "daoImplementation";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelAttribute.class}, defaultValue="true", documentation="Specifies if an nm-multiplicity attribute (or all nm-multiplicity attributes of a given model) needs an index in db (Hibernate mapping)")
    public static final String TAG_INDEX_FOREIGN_KEYS = "indexForeignKeys";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelClassifier.class}, documentation="To generate deterministic foreign keys names in hibernate mappings.")
    public static final String TAG_GENERATE_FOREIGN_KEY_NAMES = "generateForeignKeyNames";
    @TagValueDefinition(target={ObjectModel.class}, documentation="Change the super class to use when generating PersistenceContext.")
    public static final String TAG_PERSISTENCE_CONTEXT_SUPER_CLASS = "persistenceContextSuperClass";
    @TagValueDefinition(target={ObjectModel.class}, documentation="Change the super class to use when generating ApplicationContext.")
    public static final String TAG_APPLICATION_CONTEXT_SUPER_CLASS = "applicationContextSuperClass";
    @TagValueDefinition(target={ObjectModelClassifier.class, ObjectModelPackage.class, ObjectModel.class}, documentation="Change the super class to use when generating dao.")
    public static final String TAG_DAO_SUPER_CLASS = "daoSuperClass";
    @TagValueDefinition(target={ObjectModelClassifier.class, ObjectModelPackage.class, ObjectModel.class}, documentation="Change the super class to use when generating Entity.")
    public static final String TAG_ENTITY_SUPER_CLASS = "entitySuperClass";
    @TagValueDefinition(target={ObjectModelAttribute.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModel.class}, documentation="Change the super class to use when generating Entity.", matcherClass=StartsWithTagNameMatcher.class)
    public static final String TAG_HIBERNATE_ATTRIBUTE_TYPE = "hibernateAttributeType";
    @TagValueDefinition(target={ObjectModelAttribute.class, ObjectModelPackage.class, ObjectModelClassifier.class, ObjectModel.class}, documentation="Change an attribute type.", matcherClass=StartsWithTagNameMatcher.class)
    public static final String TAG_ATTRIBUTE_TYPE = "attributeType";
    @TagValueDefinition(target={ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class}, defaultValue="false", documentation="To generate property change support in entities")
    public static final String TAG_GENERATE_PROPERTY_CHANGE_SUPPORT = "generatePropertyChangeSupport";
    protected static final Map<String, String> HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES;

    public String getPersistenceTypeTagValue(ObjectModelClassifier classifier) {
        String value = this.findTagValue(TAG_PERSISTENCE_TYPE, new TagValueAble[]{classifier});
        return value;
    }

    public String getInheritanceStrategyTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage) {
        String value = this.findTagValue(TAG_INHERITANCE_STRATEGY, new TagValueAble[]{classifier, aPackage});
        return value;
    }

    public String getDbNameTagValue(ObjectModelElement element) {
        String value = this.findDirectTagValue(TAG_DB_NAME, new TagValueAble[]{null, element});
        return value;
    }

    public String getDbSchemaNameTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = this.findTagValue(TAG_SCHEMA_NAME, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public String getManytoManyTableNameTagValue(ObjectModelAttribute attribute) {
        String value = attribute.getTagValue(TAG_MANY_TO_MANY_TABLE_NAME);
        return value;
    }

    public String getLengthTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_LENGTH, new TagValueAble[]{attribute});
        return value;
    }

    public String getAnnotationTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_ANNOTATION, new TagValueAble[]{attribute});
        return value;
    }

    public String getAccessTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_ACCESS, new TagValueAble[]{attribute});
        return value;
    }

    public boolean getNaturalIdTagValue(ObjectModelAttribute attribute) {
        boolean value = this.findBooleanTagValue(TAG_NATURAL_ID, new TagValueAble[]{attribute});
        return value;
    }

    public boolean getNaturalIdMutableTagValue(ObjectModelClassifier classifier) {
        boolean value = this.findBooleanTagValue(TAG_NATURAL_ID_MUTABLE, new TagValueAble[]{classifier});
        return value;
    }

    public boolean getContextableTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_CONTEXTABLE, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public String getInverseTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_INVERSE, new TagValueAble[]{attribute});
        return value;
    }

    public String getLazyTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_LAZY, new TagValueAble[]{attribute});
        return value;
    }

    public String getFetchTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_FETCH, new TagValueAble[]{attribute});
        return value;
    }

    public String getOrderByTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_ORDER_BY, new TagValueAble[]{attribute});
        return value;
    }

    public Boolean getNotNullTagValue(ObjectModelAttribute attribute) {
        Boolean value = this.findNullableBooleanTagValue(TAG_NOT_NULL, new TagValueAble[]{attribute});
        return value;
    }

    public String getProxyInterfaceTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = this.findTagValue(TAG_PROXY_INTERFACE, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public boolean getNotGenerateToStringTagValue(ObjectModelClassifier clazz, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_NOT_GENERATE_TO_STRING, new TagValueAble[]{clazz, aPackage, model});
        return value;
    }

    public boolean getSortAttributeTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_SORT_ATTRIBUTE, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public boolean isGenerateForeignKeyNames(ObjectModelClassifier classifier, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_GENERATE_FOREIGN_KEY_NAMES, new TagValueAble[]{classifier, model});
        return value;
    }

    public String getHibernateAttributeType(ObjectModelAttribute attribute, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findDirectTagValue((String)TAG_HIBERNATE_ATTRIBUTE_TYPE, null, (TagValueAble[])new TagValueAble[]{attribute});
        if (value == null) {
            String tagValueName = "hibernateAttributeType." + attribute.getType();
            String defaultValue = HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.get(attribute.getType());
            value = TagValues.findTagValue((String)tagValueName, (String)defaultValue, (TagValueAble[])new TagValueAble[]{attribute, classifier, aPackage, model});
        }
        return value;
    }

    public String getAttributeType(ObjectModelAttribute attribute, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValues.findDirectTagValue((String)TAG_ATTRIBUTE_TYPE, null, (TagValueAble[])new TagValueAble[]{attribute});
        if (value == null) {
            String tagValueName = "attributeType." + attribute.getType();
            value = TagValues.findTagValue((String)tagValueName, (String)null, (TagValueAble[])new TagValueAble[]{attribute, classifier, aPackage, model});
        }
        return value;
    }

    public String getSqlTypeTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_SQL_TYPE, new TagValueAble[]{attribute});
        return value;
    }

    public String getDaoImplementationTagValue(ObjectModel model) {
        String value = this.findTagValue(TAG_DAO_IMPLEMENTATION, new TagValueAble[]{model});
        return value;
    }

    public boolean getIndexForeignKeysTagValue(ObjectModelAttribute attribute, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_INDEX_FOREIGN_KEYS, new TagValueAble[]{attribute, aPackage, model});
        return value;
    }

    public boolean hasUseEnumerationNameTagValue(ObjectModelAttribute attr, ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_USE_ENUMERATION_NAME, new TagValueAble[]{attr, classifier, aPackage, model});
        return value;
    }

    public String getPersistenceContextSuperClassTagValue(ObjectModel model) {
        String value = this.findTagValue(TAG_PERSISTENCE_CONTEXT_SUPER_CLASS, new TagValueAble[]{model});
        return value;
    }

    public String getApplicationContextSuperClassTagValue(ObjectModel model) {
        String value = this.findTagValue(TAG_APPLICATION_CONTEXT_SUPER_CLASS, new TagValueAble[]{model});
        return value;
    }

    public String getDaoSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = this.findTagValue(TAG_DAO_SUPER_CLASS, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public String getEntitySuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = this.findTagValue(TAG_ENTITY_SUPER_CLASS, new TagValueAble[]{classifier, aPackage, model});
        return value;
    }

    public boolean getGenerateOperatorForDAOHelperTagValue(ObjectModel model) {
        boolean value = this.findBooleanTagValue(TAG_GENERATE_OPERATOR_FOR_DAO_HELPER, new TagValueAble[]{model});
        return value;
    }

    public boolean isGeneratePropertyChangeSupport(ObjectModelClass clazz, ObjectModel model) {
        ObjectModelPackage modelPackage = model.getPackage((ObjectModelClassifier)clazz);
        boolean value = this.findBooleanTagValue(TAG_GENERATE_PROPERTY_CHANGE_SUPPORT, new TagValueAble[]{clazz, modelPackage, model});
        return value;
    }

    @Deprecated
    public String getTypeTagValue(ObjectModelAttribute attribute) {
        String value = this.findTagValue(TAG_TYPE, new TagValueAble[]{attribute});
        return value;
    }

    public String getDeprecatedAttributeTagValueMessage(ObjectModelClass clazz, ObjectModelAttribute attr, String deprecatedTagValue, String newTagValue, String value) {
        String tagValuePrefix = clazz.getQualifiedName() + ".attribute." + attr.getName() + ".tagValue.";
        String deprecatedTagName = tagValuePrefix + deprecatedTagValue + "=" + value;
        String tagName = tagValuePrefix + newTagValue + "=" + value;
        return "\n---------\nYou are using a deprecated tagValue (" + deprecatedTagName + "), replace it by\n" + tagName + "\n---------\n";
    }

    public String getDeprecatedModelTagValueMessage(ObjectModel model, String deprecatedTagValue, String newTagValue, String value) {
        String tagValuePrefix = "model.tagValue.";
        String deprecatedTagName = tagValuePrefix + deprecatedTagValue + "=" + value;
        String tagName = tagValuePrefix + newTagValue + "=" + value;
        return "\n---------\nYou are using a deprecated tagValue (" + deprecatedTagName + "), replace it by\n" + tagName + "\n---------\n";
    }

    static {
        INSTANCE.init();
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES = Maps.newHashMap();
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(String.class.getSimpleName(), String.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Boolean.class.getSimpleName(), Boolean.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Byte.class.getSimpleName(), Byte.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Character.class.getSimpleName(), Character.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Short.class.getSimpleName(), Short.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Integer.class.getSimpleName(), Integer.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Long.class.getSimpleName(), Long.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Float.class.getSimpleName(), Float.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Double.class.getSimpleName(), Double.class.getName());
        HIBERNATE_ATTRIBUTE_TYPE_DEFAULT_VALUES.put(Blob.class.getSimpleName(), Blob.class.getName().toLowerCase());
    }
}

