package org.nuiton.topia.security.entities.user;

import java.util.Collection;
import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.listener.NoSecurityLoad;

@SearchFields (
  txtFields={TopiaGroup.NAME, TopiaGroup.DESCRIPTION}
)

public interface TopiaGroup extends NoSecurityLoad, TopiaEntity {     String NAME = "name";
     String DESCRIPTION = "description";
     String TOPIA_USER = "topiaUser";
     String SUPER_GROUP = "superGroup";
     String SUB_GROUP = "subGroup";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setDescription :
     * @param description La valeur de l'attribut description à positionner.
     */

     void setDescription(String description);

    /**
     * getDescription :
     * @return String 
     */

     String getDescription();

    /**
     * addTopiaUser :
     * @param topiaUser L'instance de topiaUser à ajouter
     */

     void addTopiaUser(TopiaUser topiaUser);

    /**
     * addAllTopiaUser :
     * @param topiaUser Les instances de topiaUser à ajouter
     */

     void addAllTopiaUser(Collection<TopiaUser> topiaUser);

    /**
     * setTopiaUser :
     * @param topiaUser La Collection de topiaUser à ajouter
     */

     void setTopiaUser(Collection<TopiaUser> topiaUser);

    /**
     * removeTopiaUser :
     * @param topiaUser Vide la Collection de topiaUser
     */

     void removeTopiaUser(TopiaUser topiaUser);

    /**
     * clearTopiaUser :
     */

     void clearTopiaUser();

    /**
     * getTopiaUser :
     * @return Collection<TopiaUser> 
     */

     Collection<TopiaUser> getTopiaUser();

    /**
     * getTopiaUserByTopiaId :
     * Recupère l'attribut topiaUser à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TopiaUser 
     */

     TopiaUser getTopiaUserByTopiaId(String topiaId);

    /**
     * sizeTopiaUser :
     * Retourne le nombre d'éléments de la collection topiaUser
     * @return int 
     */

     int sizeTopiaUser();

    /**
     * isTopiaUserEmpty :
     * Retourne {@code true} si la collection topiaUser est vide.
     * @return boolean 
     */

     boolean isTopiaUserEmpty();

    /**
     * setSuperGroup :
     * @param superGroup La valeur de l'attribut superGroup à positionner.
     */

     void setSuperGroup(TopiaGroup superGroup);

    /**
     * getSuperGroup :
     * @return TopiaGroup 
     */

     TopiaGroup getSuperGroup();

    /**
     * addSubGroup :
     * @param subGroup L'instance de subGroup à ajouter
     */

     void addSubGroup(TopiaGroup subGroup);

    /**
     * addAllSubGroup :
     * @param subGroup Les instances de subGroup à ajouter
     */

     void addAllSubGroup(Collection<TopiaGroup> subGroup);

    /**
     * setSubGroup :
     * @param subGroup La Collection de subGroup à ajouter
     */

     void setSubGroup(Collection<TopiaGroup> subGroup);

    /**
     * removeSubGroup :
     * @param subGroup Vide la Collection de subGroup
     */

     void removeSubGroup(TopiaGroup subGroup);

    /**
     * clearSubGroup :
     */

     void clearSubGroup();

    /**
     * getSubGroup :
     * @return Collection<TopiaGroup> 
     */

     Collection<TopiaGroup> getSubGroup();

    /**
     * getSubGroupByTopiaId :
     * Recupère l'attribut subGroup à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TopiaGroup 
     */

     TopiaGroup getSubGroupByTopiaId(String topiaId);

    /**
     * sizeSubGroup :
     * Retourne le nombre d'éléments de la collection subGroup
     * @return int 
     */

     int sizeSubGroup();

    /**
     * isSubGroupEmpty :
     * Retourne {@code true} si la collection subGroup est vide.
     * @return boolean 
     */

     boolean isSubGroupEmpty();

    /**
     * getAllUser :
     * @return List 
     */

     List getAllUser();

    /**
     * getAllSuperGroup :
     * @return List 
     */

     List getAllSuperGroup();


} //TopiaGroup
