/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.event.TopiaContextAdapter;
import org.nuiton.topia.event.TopiaContextEvent;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TMSVersionPersister;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.migration.mappings.TMSVersionDAO;
import org.nuiton.util.version.Version;

public class TopiaMigrationEngine
implements TopiaMigrationService {
    private static final Log log = LogFactory.getLog(TopiaMigrationEngine.class);
    protected TMSVersionPersister tmsVersionPersister;
    protected Version dbVersion;
    protected boolean dbNotVersioned;
    protected boolean dbEmpty;
    protected boolean migrateOnInit;
    protected AbstractTopiaMigrationCallback callback;
    protected TopiaContextImplementor rootContext;
    protected boolean init;
    protected boolean versionDetected;
    protected boolean showSql;
    protected boolean showProgression;
    protected final TopiaContextListener contextListener;
    protected final TopiaTransactionVetoable transactionVetoable = new TopiaTransactionVetoable(){

        public void beginTransaction(TopiaTransactionEvent event) {
            TopiaContextImplementor context = (TopiaContextImplementor)event.getSource();
            context.addTopiaContextListener(TopiaMigrationEngine.this.contextListener);
        }
    };

    public TopiaMigrationEngine() {
        this.contextListener = new TopiaContextAdapter(){

            public void postCreateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postCreateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postUpdateSchema(TopiaContextEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"postUpdateSchema event called : will save version in database");
                }
                TopiaMigrationEngine.this.saveApplicationVersion();
            }

            public void postRestoreSchema(TopiaContextEvent event) {
                block5: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"postRestoreSchema event detected, redo, schema migration");
                    }
                    if (TopiaMigrationEngine.this.migrateOnInit) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Starts Migrate from postRestoreSchema...");
                        }
                        try {
                            TopiaMigrationEngine.this.doMigrateSchema();
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block5;
                            log.error((Object)("postRestoreSchema schema migration failed for reason " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        };
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{TMSVersion.class};
    }

    public String getServiceName() {
        return "migration";
    }

    public boolean preInit(TopiaContextImplementor context) {
        this.rootContext = context;
        Properties config = context.getConfig();
        String callbackStr = this.getSafeParameter(config, "topia.service.migration.callback");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use callback            - " + callbackStr));
        }
        this.migrateOnInit = Boolean.valueOf(config.getProperty("topia.service.migration.no.migrate.on.init", String.valueOf(Boolean.TRUE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate on init         - " + this.migrateOnInit));
        }
        this.showSql = Boolean.valueOf(config.getProperty("topia.service.migration.showSql", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show sql                - " + this.showSql));
        }
        this.showProgression = Boolean.valueOf(config.getProperty("topia.service.migration.showProgression", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show progression        - " + this.showProgression));
        }
        try {
            Class<?> clazz = Class.forName(callbackStr);
            this.callback = (AbstractTopiaMigrationCallback)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not instanciate CallbackHandler [" + callbackStr + "]"), (Throwable)e);
        }
        Configuration configuration = new Configuration();
        for (Class<?> aClass : this.getPersistenceClasses()) {
            configuration.addClass(aClass);
        }
        Configuration versionConfiguration = this.createHibernateConfiguration(configuration);
        Configuration conf = new Configuration();
        conf.addXML(TMSVersionDAO.LEGACY_MAPPING);
        Configuration legacyVersionConfiguration = this.createHibernateConfiguration(conf);
        this.tmsVersionPersister = new TMSVersionPersister(versionConfiguration, legacyVersionConfiguration);
        this.init = true;
        context.addTopiaContextListener(this.contextListener);
        context.addTopiaTransactionVetoable(this.transactionVetoable);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] is init."));
        }
        if (this.migrateOnInit) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starts Migrate from preInit...");
                }
                this.doMigrateSchema();
            }
            catch (MigrationServiceException e) {
                throw new TopiaRuntimeException("Can't migrate schema for reason " + e.getMessage(), (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this + "] skip migration on init as required"));
        }
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        return true;
    }

    public void doMigrateSchema() throws MigrationServiceException {
        boolean complete = this.migrateSchema();
        if (!complete) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"topia.migration.migration.incomplete", (Object[])new Object[0]));
            }
            throw new TopiaRuntimeException(I18n.t((String)"topia.migration.migration.incomplete", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean migrateSchema() throws MigrationServiceException {
        this.checkInit();
        this.detectDbVersion();
        Version version = this.callback.getApplicationVersion();
        log.info((Object)I18n.t((String)"topia.migration.start.migration", (Object[])new Object[]{version.getVersion(), this.dbVersion.getVersion()}));
        boolean versionTableExist = this.tmsVersionPersister.isVersionTableExist();
        boolean legacyVersionTableExist = this.tmsVersionPersister.isLegacyVersionTableExist();
        if (log.isDebugEnabled()) {
            log.debug((Object)("is db not versionned ?    = " + this.dbNotVersioned));
            log.debug((Object)("is db empty ?             = " + this.dbEmpty));
            log.debug((Object)("TMSVersion exists ?       = " + versionTableExist));
            log.debug((Object)("LegacyTMSVersion exists ? = " + legacyVersionTableExist));
            log.debug((Object)("Update from version       = " + this.dbVersion));
            log.debug((Object)("Update to version         = " + version));
        }
        if (this.dbEmpty) {
            return true;
        }
        if (versionTableExist && this.dbVersion.equals((Object)version)) {
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"topia.migration.skip.migration.db.is.up.to.date", (Object[])new Object[0]));
            }
            return true;
        }
        if (versionTableExist && this.dbNotVersioned && this.migrateOnInit) {
            log.info((Object)I18n.t((String)"topia.migration.skip.migration.db.is.empty", (Object[])new Object[0]));
            this.saveApplicationVersion();
            return true;
        }
        if (legacyVersionTableExist && this.dbVersion.equals((Object)version)) {
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"topia.migration.skip.migration.db.is.up.to.date", (Object[])new Object[0]));
            }
            this.saveApplicationVersion();
            return true;
        }
        TreeSet<Version> allVersions = new TreeSet<Version>();
        allVersions.addAll(Arrays.asList(this.callback.getAvailableVersions()));
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"topia.migration.available.versions", (Object[])new Object[]{allVersions}));
        }
        boolean needToMigrate = false;
        if (this.dbVersion.before(version)) {
            List<Version> versionsToApply = this.filterVersions(allVersions, this.dbVersion, version, false, true);
            if (versionsToApply.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"topia.migration.skip.migration.no.version.to.apply", (Object[])new Object[0]));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"topia.migration.migrate.versions", (Object[])new Object[]{versionsToApply}));
                }
                this.callback.setTmsVersionPersister(this.tmsVersionPersister);
                needToMigrate = this.callback.doMigration((TopiaContext)this.rootContext, this.dbVersion, this.showSql, this.showProgression, versionsToApply);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handler choose : " + needToMigrate));
                }
                if (!needToMigrate) {
                    return false;
                }
            }
        }
        if (!versionTableExist || needToMigrate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set application version in database to " + version));
            }
            this.saveApplicationVersion();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveApplicationVersion() {
        this.checkInit();
        Version version = this.callback.getApplicationVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save application version = " + version));
        }
        try {
            TopiaContext tx = this.rootContext.beginTransaction();
            try {
                this.tmsVersionPersister.saveVersion(tx, version);
                tx.commitTransaction();
            }
            finally {
                if (tx != null) {
                    tx.closeContext();
                }
            }
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException("Can't save application version for reason " + e.getMessage(), (Throwable)e);
        }
        this.dbVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectDbVersion() {
        Version v;
        block17: {
            block15: {
                block13: {
                    block16: {
                        block14: {
                            if (this.versionDetected) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("version was already detected : " + this.dbVersion));
                                }
                                return;
                            }
                            this.dbEmpty = this.detectDbEmpty();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Db is empty : " + this.dbEmpty));
                            }
                            v = null;
                            try {
                                boolean versionTableExist = this.tmsVersionPersister.isVersionTableExist();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Table tms_version exist = " + versionTableExist));
                                }
                                if (!versionTableExist) break block13;
                                v = this.getVersion(true, "tms_version");
                                if (log.isWarnEnabled() && v == null) {
                                    log.warn((Object)"Version not found on table tms_version");
                                }
                                if (v != null) break block14;
                                v = Version.VZERO;
                                this.dbNotVersioned = true;
                            }
                            catch (Throwable throwable) {
                                if (v == null) {
                                    v = Version.VZERO;
                                    this.dbNotVersioned = true;
                                    log.info((Object)I18n.t((String)"topia.migration.db.not.versionned", (Object[])new Object[0]));
                                } else {
                                    log.info((Object)I18n.t((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
                                }
                                this.dbVersion = v;
                                this.versionDetected = true;
                                throw throwable;
                            }
                            log.info((Object)I18n.t((String)"topia.migration.db.not.versionned", (Object[])new Object[0]));
                            break block16;
                        }
                        log.info((Object)I18n.t((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
                    }
                    this.dbVersion = v;
                    this.versionDetected = true;
                    return;
                }
                boolean legacyVersionTableExist = this.tmsVersionPersister.isLegacyVersionTableExist();
                if (legacyVersionTableExist) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Legacy : detected tmsVersion table");
                    }
                    if ((v = this.getVersion(true, "tmsVersion")) != null && log.isDebugEnabled()) {
                        log.debug((Object)("Legacy : " + I18n.t((String)"topia.migration.detected.db.version", (Object[])new Object[]{v})));
                    }
                }
                if (v != null) break block15;
                v = Version.VZERO;
                this.dbNotVersioned = true;
                log.info((Object)I18n.t((String)"topia.migration.db.not.versionned", (Object[])new Object[0]));
                break block17;
            }
            log.info((Object)I18n.t((String)"topia.migration.detected.db.version", (Object[])new Object[]{v}));
        }
        this.dbVersion = v;
        this.versionDetected = true;
    }

    protected boolean detectDbEmpty() {
        try {
            Configuration rootConfiguration = this.rootContext.getHibernateConfiguration();
            boolean result = TopiaUtil.isSchemaEmpty((Configuration)rootConfiguration);
            return result;
        }
        catch (TopiaNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version getVersion(boolean versionTableExist, String tableName) {
        Version version;
        block7: {
            if (!versionTableExist) {
                return null;
            }
            TopiaContext tx = this.rootContext.beginTransaction();
            try {
                Version v;
                version = v = TMSVersionDAO.getVersion(tx, tableName);
                if (tx == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        tx.closeContext();
                    }
                    throw throwable;
                }
                catch (TopiaException e) {
                    throw new TopiaRuntimeException("Can't obtain dbVersion for reason " + e.getMessage(), (Throwable)e);
                }
            }
            tx.closeContext();
        }
        return version;
    }

    protected String getSafeParameter(Properties config, String key) {
        String value = config.getProperty(key, null);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalStateException("'" + key + "' not set.");
        }
        return value;
    }

    protected void checkInit() {
        if (!this.init) {
            throw new IllegalStateException("le service n'est pas initialis\u00e9!");
        }
    }

    @Deprecated
    protected Configuration creaHibernateConfiguration(Configuration configuration) {
        return this.createHibernateConfiguration(configuration);
    }

    protected Configuration createHibernateConfiguration(Configuration configuration) {
        Properties config = this.rootContext.getConfig();
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)configuration.getProperties());
        prop.putAll((Map<?, ?>)config);
        configuration.setProperties(prop);
        configuration.buildMappings();
        return configuration;
    }

    protected List<Version> filterVersions(Set<Version> versions, Version min, Version max, boolean includeMin, boolean includeMax) {
        ArrayList<Version> toApply = new ArrayList<Version>();
        for (Version v : versions) {
            int t;
            if (min != null && ((t = v.compareTo(min)) < 0 || t == 0 && !includeMin) || max != null && ((t = v.compareTo(max)) > 0 || t == 0 && !includeMax)) continue;
            toApply.add(v);
        }
        return toApply;
    }
}

