/* *##% ToPIA - Migration service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.migration.common;

/**
 * ExceptionAttributeUndefined.java
 *
 * Lancee si le developpeur tente d'acceder a des attribut non existant.
 *  
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public class ExceptionAttributeUndefined extends Exception {

	/**
	 * Version UID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructeur par defaut
	 */
	public ExceptionAttributeUndefined() {
		super();
	}

	/**
	 * Constructeur avec message
	 * @param message
	 */
	public ExceptionAttributeUndefined(String message) {
		super(message);
	}

	/**
	 * Constructeur avec exception
	 * @param cause
	 */
	public ExceptionAttributeUndefined(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructeur avec message et exception
	 * @param message
	 * @param cause
	 */
	public ExceptionAttributeUndefined(String message, Throwable cause) {
		super(message, cause);
	}
}
