/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNotFoundException;

public class LegacyTopiaIdFactory
implements TopiaIdFactory {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LegacyTopiaIdFactory.class);

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + String.valueOf(entityClass));
        }
        double random = Math.random();
        while (Double.toString(random).contains("E-")) {
            random = Math.random();
        }
        return entityClass.getName() + this.getSeparator() + System.currentTimeMillis() + "#" + random;
    }

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, String randomPart) {
        return entityClass.getName() + this.getSeparator() + System.currentTimeMillis() + "#" + randomPart;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException eee) {
            throw new TopiaNotFoundException("Can't find class for " + topiaId, eee);
        }
    }

    @Override
    public String getSeparator() {
        return "#";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringAfter((String)topiaId, (String)this.getSeparator());
    }

    @Override
    public boolean isTopiaId(String str) {
        boolean isTopiaId;
        block4: {
            String[] split;
            isTopiaId = false;
            if (str != null && (split = str.split(this.getSeparator())).length >= 2) {
                String className = split[0];
                try {
                    Class.forName(className);
                    isTopiaId = true;
                    for (int index = 1; index < split.length; ++index) {
                        isTopiaId &= StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{split[index]});
                    }
                }
                catch (ClassNotFoundException eee) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)eee);
                }
            }
        }
        return isTopiaId;
    }
}

