package org.nuiton.topia.persistence.support;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaServiceSupport.java 3088 2014-04-30 11:17:38Z bleny $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-7/topia-persistence/src/main/java/org/nuiton/topia/persistence/support/TopiaServiceSupport.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaService;

import java.util.Map;

/**
 * This API provides methods to manipulate services
 *
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 3.0
 */
public interface TopiaServiceSupport {

    /**
     * The list of registered services. The map key is the service name, and the value is the service instance.
     */
    Map<String, TopiaService> getServices();

    /**
     * Same as {@link #getServices()} but returns only services that implements
     * given contract (or is instance of given class).
     */
    <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService);

}
