package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaReplicationDestination.java 2983 2014-01-18 18:21:51Z athimel $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-6/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaReplicationDestination.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Represent the destination of a replication process. The source is
 * {@link org.nuiton.topia.persistence.support.TopiaReplicationSupport}
 *
 * @since 3.0
 */
public interface TopiaReplicationDestination {

    /**
     * Must replicate given entity in current database
     *
     * @param entity the remote entity to replicate
     * @since 3.0
     */
    void replicate(TopiaEntity entity);

}
