/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.metadata;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.metadata.MetaFilenameAware;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;
import org.nuiton.util.ObjectUtil;

public class AssociationMeta<T extends TopiaEntityEnum>
implements Serializable,
MetaFilenameAware<T> {
    private static final long serialVersionUID = 1L;
    protected final T source;
    protected final T target;
    protected final String name;
    protected transient EntityOperator<TopiaEntity> operator;

    protected static <T extends TopiaEntityEnum> AssociationMeta<T> newMeta(T source, T target, String name) {
        return new AssociationMeta<T>(source, target, name);
    }

    public AssociationMeta(T source, T target, String name) {
        this.source = source;
        this.target = target;
        this.name = name;
    }

    @Override
    public T getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilename() {
        return this.source.name() + "_" + this.name + ".csv";
    }

    @Override
    public File newFile(File container) {
        return new File(container, this.getFilename());
    }

    @Override
    public Writer newWriter(File container) {
        File file = this.newFile(container);
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TopiaException("Could not find file " + file);
        }
    }

    public T getTarget() {
        return this.target;
    }

    public TopiaEntity newEntity() {
        return (TopiaEntity)ObjectUtil.newInstance(this.source.getImplementation(), (String[])new String[0]);
    }

    public Object newAssociation() {
        return ObjectUtil.newInstance(this.target.getImplementation(), (String[])new String[0]);
    }

    public Collection<TopiaEntity> getChilds(TopiaEntity entity) {
        Object o = this.getOperator().get(this.name, entity);
        return (Collection)o;
    }

    public void setChilds(TopiaEntity entity, Collection<TopiaEntity> childs) {
        this.getOperator().addAllChild(this.name, entity, childs);
    }

    public boolean isChildEmpty(TopiaEntity entity) {
        boolean result = this.getOperator().isChildEmpty(this.name, entity);
        return result;
    }

    public EntityOperator<TopiaEntity> getOperator() {
        if (this.operator == null) {
            this.operator = EntityOperatorStore.getOperator(this.source);
        }
        return this.operator;
    }

    public String toString() {
        return "<" + this.source + ":" + this.name + " " + this.target + ">";
    }
}

