/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.AbstractTopiaApplicationContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;

public class TopiaApplicationContextCache {
    private static final Log log = LogFactory.getLog(TopiaApplicationContextCache.class);
    protected static Map<Properties, AbstractTopiaApplicationContext> contextCache = new ReferenceMap(0, 1);

    public static <C extends AbstractTopiaApplicationContext> C getContext(Properties config, Function<Properties, C> createContextFunction) throws TopiaNotFoundException {
        Properties cloned = new Properties();
        for (String key : config.stringPropertyNames()) {
            cloned.setProperty(key, config.getProperty(key));
        }
        AbstractTopiaApplicationContext result = contextCache.get(cloned);
        if (result == null || result.isClosed()) {
            if (createContextFunction == null) {
                throw new TopiaException("Function<Properties, AbstractTopiaApplicationContext> is required to create context");
            }
            result = (AbstractTopiaApplicationContext)createContextFunction.apply((Object)cloned);
            if (log.isDebugEnabled()) {
                log.debug((Object)("New context created : " + result));
            }
            contextCache.put(cloned, result);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Context found : " + result));
        }
        return (C)result;
    }

    public static List<String> getRegisteredContextUrls() {
        ArrayList result = Lists.newArrayList();
        for (Properties e : contextCache.keySet()) {
            result.add(e.getProperty("hibernate.connection.url"));
        }
        return result;
    }

    public static void removeContext(AbstractTopiaApplicationContext context) {
        Iterator<AbstractTopiaApplicationContext> it = contextCache.values().iterator();
        while (it.hasNext()) {
            AbstractTopiaApplicationContext curr = it.next();
            if (curr != context) continue;
            it.remove();
            break;
        }
    }
}

