/*
 * #%L
 * 
 * 
 * $Id: TopiaEntityContextable.java 2846 2013-10-17 16:14:18Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntityContextable.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDaoSupplier;

/**
 * {@link TopiaEntity} with {@link TopiaContext} support (injected by
 * {@link TopiaContext} into entities).
 *
 * @author chatellier
 * @version $Revision: 2846 $
 *          <p/>
 *          Last update : $Date: 2013-10-17 18:14:18 +0200 (Thu, 17 Oct 2013) $
 *          By : $Author: bleny $
 */
public interface TopiaEntityContextable extends TopiaEntity {

    /**
     * Update entity in persistence context.
     */
    void update();

    /**
     * Delete entity in persistence context.
     */
    void delete();

    void setTopiaDAOSupplier(TopiaDaoSupplier topiaDAO);

    TopiaDaoSupplier getTopiaDAOSupplier();

}
