/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaHibernateSupport;
import org.nuiton.topia.TopiaJpaSupport;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.framework.TopiaUtil;

public class HibernateTopiaJpaSupport
implements TopiaJpaSupport {
    private static final Log log = LogFactory.getLog(HibernateTopiaJpaSupport.class);
    protected TopiaHibernateSupport hibernateSupport;
    protected TopiaFiresSupport firesSupport;
    protected boolean useFlushMode = true;

    public HibernateTopiaJpaSupport(TopiaHibernateSupport hibernateSupport, TopiaFiresSupport firesSupport) {
        this.hibernateSupport = hibernateSupport;
        this.firesSupport = firesSupport;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    protected Query prepareQuery(String jpaql, Map<String, Object> parameters) {
        Query query = this.hibernateSupport.getHibernateSession().createQuery(jpaql);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray()) {
                query.setParameterList(name, (Object[])value);
                continue;
            }
            if (value instanceof Collection) {
                query.setParameterList(name, (Collection)value);
                continue;
            }
            query.setParameter(name, value);
        }
        if (this.useFlushMode) {
            query.setFlushMode(FlushMode.AUTO);
        }
        return query;
    }

    @Override
    public <T> List<T> findAll(String jpaql, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs during query operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("exception occurred for query \n" + jpaql + "\nwith parameters " + parameters));
            }
            throw e;
        }
    }

    @Override
    public <T> T findUnique(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find(jpaql, 0, 1, parameters);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", jpaql);
            throw new TopiaException(message);
        }
        T result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    @Override
    public <T> List<T> find(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            query.setFirstResult(startIndex);
            query.setMaxResults(endIndex - startIndex + 1);
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs during query operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("exception occurred for query \n" + jpaql + "\nwith parameters " + parameters));
            }
            throw e;
        }
    }

    @Override
    public int execute(String jpaql, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            int result = query.executeUpdate();
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("An error occurs during execute operation: %1$s : %2$s", jpaql, eee.getMessage()), eee);
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("exception occurred for query \n" + jpaql + "\nwith parameters " + parameters));
            }
            throw e;
        }
    }

    @Override
    public <T> List<T> findAll(String jpaql, Object ... propertyNamesAndValues) {
        Map<String, Object> parameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        List<T> result = this.findAll(jpaql, parameters);
        return result;
    }

    @Override
    public <T> List<T> find(String jpaql, int startIndex, int endIndex, Object ... propertyNamesAndValues) {
        Map<String, Object> parameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        List<T> result = this.find(jpaql, startIndex, endIndex, parameters);
        return result;
    }

    @Override
    public <T> T findUnique(String jpaql, Object ... propertyNamesAndValues) {
        Map<String, Object> parameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        T result = this.findUnique(jpaql, parameters);
        return result;
    }

    @Override
    public int execute(String jpaql, Object ... propertyNamesAndValues) {
        Map<String, Object> parameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        int result = this.execute(jpaql, parameters);
        return result;
    }
}

