/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.csv.ext.AbstractImportExportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.csv.TopiaCsvCommons;
import org.nuiton.topia.persistence.metadata.TableMeta;

public class EntityCsvModel<T extends TopiaEntityEnum, E extends TopiaEntity>
extends AbstractImportExportModel<E> {
    protected final TableMeta<T> tableMeta;
    protected boolean useOrdinalForEnum;

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> EntityCsvModel<T, E> newModel(char separator, TableMeta<T> tableMeta) {
        return new EntityCsvModel<T, E>(separator, tableMeta);
    }

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> EntityCsvModel<T, E> newModel(char separator, TableMeta<T> tableMeta, String idHeader) {
        return new EntityCsvModel<T, E>(separator, tableMeta, idHeader);
    }

    public E newEmptyInstance() {
        return (E)this.tableMeta.newEntity();
    }

    public void setUseOrdinalForEnum(boolean useOrdinalForEnum) {
        this.useOrdinalForEnum = useOrdinalForEnum;
    }

    public void addForeignKeyForExport(String propertyName, Class<TopiaEntity> entityType) {
        Map universe = Collections.emptyMap();
        this.newColumnForExport(propertyName, (ValueFormatter)TopiaCsvCommons.newForeignKeyValue(entityType, propertyName, universe));
    }

    public <T> void addDecoratedForeignKeyForExport(String headerName, String propertyName, Decorator<T> decorator) {
        this.modelBuilder.newColumnForExport(headerName, propertyName, TopiaCsvCommons.newForeignKeyDecoratedValue(decorator));
    }

    public <E extends TopiaEntity> void addForeignKeyForImport(String headerName, String propertyName, Class<E> entityType, Collection<E> entities, Function<E, String> transform) {
        ImmutableMap universe = Maps.uniqueIndex(entities, transform);
        this.newMandatoryColumn(headerName, propertyName, (ValueParser)TopiaCsvCommons.newForeignKeyValue(entityType, propertyName, universe));
    }

    public <E extends TopiaEntity> void addForeignKeyForAssociationForImport(String headerName, String propertyName, Class<E> entityType, Collection<E> entities, Function<E, String> transform) {
        ImmutableMap universe = Maps.uniqueIndex(entities, transform);
        this.newMandatoryColumn(headerName, propertyName, TopiaCsvCommons.newForeignKeyValueAssociation(entityType, propertyName, universe));
    }

    public <E extends TopiaEntity> void addForeignKeyForImport(String propertyName, Class<E> entityType, Collection<E> entities) {
        ImmutableMap universe = Maps.uniqueIndex(entities, TopiaEntities.GET_TOPIA_ID);
        this.newMandatoryColumn(propertyName, (ValueParser)TopiaCsvCommons.newForeignKeyValue(entityType, propertyName, universe));
    }

    public <E extends TopiaEntity> void addForeignKeyForImport(String propertyName, Class<E> entityType, Map<String, E> universe) {
        this.newMandatoryColumn(propertyName, (ValueParser)TopiaCsvCommons.newForeignKeyValue(entityType, propertyName, universe));
    }

    public void addDefaultColumn(String propertyName, Class<?> type) {
        this.addDefaultColumn(propertyName, propertyName, type);
    }

    public void addDefaultColumn(String headerName, String propertyName, Class<?> type) {
        if (Date.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.DAY_TIME_SECOND_WITH_TIMESTAMP);
        } else if (Double.TYPE.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.DOUBLE_PRIMITIVE);
        } else if (Double.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.DOUBLE);
        } else if (Long.TYPE.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.PRIMITIVE_LONG);
        } else if (Long.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.LONG);
        } else if (Float.TYPE.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.PRIMITIVE_FLOAT);
        } else if (Float.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.FLOAT);
        } else if (Integer.TYPE.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.PRIMITIVE_INTEGER);
        } else if (Integer.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.INTEGER);
        } else if (Boolean.TYPE.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.PRIMITIVE_BOOLEAN);
        } else if (Boolean.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName, TopiaCsvCommons.BOOLEAN);
        } else if (String.class.equals(type)) {
            this.newColumnForImportExport(headerName, propertyName);
        } else if (type.isEnum()) {
            Class<?> enumType = type;
            ValueParserFormatter valueParserFormatter = this.useOrdinalForEnum ? TopiaCsvCommons.newEnumByOrdinalParserFormatter(enumType) : TopiaCsvCommons.newEnumByNameParserFormatter(enumType);
            this.newColumnForImportExport(headerName, propertyName, valueParserFormatter);
        } else {
            throw new IllegalStateException(String.format("For header %s, property %s, no specific handler found for type %s", headerName, propertyName, type));
        }
    }

    protected EntityCsvModel(char separator, TableMeta<T> tableMeta) {
        super(separator);
        this.tableMeta = tableMeta;
    }

    protected EntityCsvModel(char separator, TableMeta<T> tableMeta, String idHeader) {
        this(separator, tableMeta);
        this.newColumnForImportExport(idHeader, "topiaId");
    }
}

