/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.ListUpdator;

public class EntityListUpdator<P extends TopiaEntity, E extends TopiaEntity>
implements ListUpdator<P, E> {
    protected String propertyName;
    protected PropertyDescriptor descriptor;
    protected Method getMethod;
    protected Method addMethod;
    protected Method removeMethod;

    public static <P extends TopiaEntity, E extends TopiaEntity> EntityListUpdator<P, E> newEntityListUpdator(Class<P> parentClass, Class<E> childClass, String propertyName) {
        return new EntityListUpdator<P, E>(parentClass, childClass, propertyName);
    }

    protected EntityListUpdator(Class<P> parentClass, Class<E> childClass, String propertyName) {
        this.propertyName = propertyName;
        for (PropertyDescriptor propertyDescriptor : new PropertyUtilsBean().getPropertyDescriptors(parentClass)) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            this.descriptor = propertyDescriptor;
        }
        String cap = StringUtils.capitalize((String)propertyName);
        try {
            this.getMethod = parentClass.getMethod("get" + cap + "ByTopiaId", String.class);
            this.addMethod = parentClass.getMethod("add" + cap, childClass);
            this.removeMethod = parentClass.getMethod("remove" + cap, childClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public E getChild(P parent, String topiaId) {
        return (E)((TopiaEntity)EntityListUpdator.invokeWithResult(this.getMethod, parent, topiaId));
    }

    @Override
    public Collection<E> getChilds(P parent) {
        return (Collection)EntityListUpdator.invokeWithResult(this.descriptor.getReadMethod(), parent, new Object[0]);
    }

    @Override
    public void setChilds(P parent, Collection<E> childs) {
        EntityListUpdator.invoke(this.descriptor.getWriteMethod(), parent, childs);
    }

    @Override
    public void addToList(P parent, E bean) throws TopiaException {
        EntityListUpdator.invoke(this.addMethod, parent, bean);
    }

    @Override
    public void removeFromList(P parent, E bean) throws TopiaException {
        EntityListUpdator.invoke(this.removeMethod, parent, bean);
    }

    protected static void invoke(Method m, Object bean, Object ... args) {
        try {
            m.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <V> V invokeWithResult(Method m, Object bean, Object ... args) {
        try {
            return (V)m.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

