/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.event;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.IdentityMap;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.framework.EntityState;
import org.nuiton.topia.persistence.TopiaEntity;

public class TopiaTransactionEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private Map<TopiaEntity, EntityState> entities = new IdentityMap();

    public TopiaTransactionEvent(TopiaContext source) {
        super(source);
    }

    public TopiaTransactionEvent(TopiaContext source, Map<TopiaEntity, EntityState> entities) {
        this(source);
        this.entities.putAll(entities);
    }

    public Set<TopiaEntity> getEntities() {
        return this.entities.keySet();
    }

    public boolean isLoad(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isLoad();
    }

    public boolean isRead(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isRead();
    }

    public boolean isCreate(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isCreate();
    }

    public boolean isUpdate(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isUpdate();
    }

    public boolean isDelete(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isDelete();
    }

    public boolean isModification(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && (state.isCreate() || state.isUpdate() || state.isDelete());
    }

    public TopiaContext getTopiaContext() {
        return (TopiaContext)super.getSource();
    }
}

