/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.persistence.util.Loador;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class BeanPropertyLoador<E>
implements Loador<E> {
    private static final long serialVersionUID = 1L;
    protected static final Integer ZERO = 0;
    protected static final Float ZEROF = Float.valueOf(0.0f);
    protected static final Long ZEROL = 0L;
    protected static final Double ZEROD = 0.0;
    protected static final Byte ZEROB = 0;
    protected List<String> properties;
    protected transient PropertyDescriptor[] descriptors;
    protected Class<E> klass;

    public static <E> BeanPropertyLoador<E> newLoador(Class<E> klass, String ... properties) {
        return new BeanPropertyLoador<E>(klass, properties);
    }

    protected BeanPropertyLoador(Class<E> klass, String ... properties) {
        this.properties = Collections.unmodifiableList(Arrays.asList(properties));
        this.klass = klass;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public PropertyDescriptor[] getDescriptors() {
        if (this.descriptors == null) {
            try {
                this.descriptors = new PropertyDescriptor[this.properties.size()];
                for (PropertyDescriptor propertydescriptor : Introspector.getBeanInfo(this.klass).getPropertyDescriptors()) {
                    int index = this.properties.indexOf(propertydescriptor.getName());
                    if (index == -1) continue;
                    this.descriptors[index] = propertydescriptor;
                }
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return this.descriptors;
    }

    @Override
    public Map<String, Object> obtainProperties(E from) {
        if (from == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : this.getDescriptors()) {
            try {
                Object read = descriptor.getReadMethod().invoke(from, new Object[0]);
                if (read == null) continue;
                result.put(descriptor.getName(), read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Map<String, Object> obtainProgperties(E from) {
        return this.obtainProperties(from);
    }

    @Override
    public void load(E from, E dst, boolean tech) {
        if (from == null) {
            for (PropertyDescriptor descriptor : this.getDescriptors()) {
                Object read = TopiaEntityHelper.getNullValue(descriptor.getPropertyType());
                this.setProperty(dst, descriptor, read);
            }
        } else {
            for (PropertyDescriptor descriptor : this.getDescriptors()) {
                try {
                    Object value = descriptor.getReadMethod().invoke(from, new Object[0]);
                    this.setProperty(dst, descriptor, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void setProperty(E dst, PropertyDescriptor descriptor, Object value) {
        try {
            descriptor.getWriteMethod().invoke(dst, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected static Object getNullValue(Class<?> type) {
        return TopiaEntityHelper.getNullValue(type);
    }

    @Deprecated
    public static boolean isNullValue(Object value) {
        return TopiaEntityHelper.isNullValue(value);
    }

    protected void checkProperties() {
        PropertyDescriptor[] d = this.getDescriptors();
        for (int i = 0; i < d.length; ++i) {
            PropertyDescriptor descriptor = d[i];
            if (descriptor == null) {
                throw new IllegalStateException("could not find descriptor for property " + this.properties.get(i) + " on " + this.klass);
            }
            if (descriptor.getReadMethod() == null) {
                throw new IllegalStateException("property " + this.properties.get(i) + " is not readable on " + this.klass);
            }
            if (descriptor.getWriteMethod() != null) continue;
            throw new IllegalStateException("property " + this.properties.get(i) + " is not writable on " + this.klass);
        }
    }
}

