package org.nuiton.topiatest.deletetest;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topiatest.Company;


public abstract class Contact2DAOAbstract<E extends Contact2> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Contact2.class;
    }

    /**
     * findAllByCompany :
     * @param company 
     * @return Set<Contact2> 
     * @throws TopiaException
     */

    public abstract Set<Contact2> findAllByCompany(Company company) throws TopiaException;

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topiatest.deletetest.Party2> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from party2 main, contacts_party2 secondary " +
                    "where main.topiaid=secondary.party2" +
                    " and secondary.contacts='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaTestDAOHelper.getImplementationClass(org.nuiton.topiatest.deletetest.Party2.class)).list();
            for (org.nuiton.topiatest.deletetest.Party2 item : list) {
                item.removeContacts(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByContactValue :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut contactValue le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByContactValue(String v) throws TopiaException {
        E result = findByProperty("contactValue", v);
        return result;
    }

    /**
     * findAllByContactValue :
     * Retourne les éléments ayant comme valeur pour l'attribut contactValue le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByContactValue(String v) throws TopiaException {
        List<E> result = findAllByProperty("contactValue", v);
        return result;
    }

    /**
     * findByType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByType(String v) throws TopiaException {
        E result = findByProperty("type", v);
        return result;
    }

    /**
     * findAllByType :
     * Retourne les éléments ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty("type", v);
        return result;
    }

    /**
     * findContainsParty2 :
     * Retourne le premier élément trouvé dont l'attribut party2 contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsParty2(Party2... v) throws TopiaException {
        E result = findContainsProperties("party2", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsParty2 :
     * Retourne les éléments trouvé dont l'attribut party2 contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsParty2(Party2... v) throws TopiaException {
        List<E> results = findAllContainsProperties("party2", Arrays.asList(v));
        return results;
    }


} //Contact2DAOAbstract<E extends Contact2>
