package org.nuiton.topiatest.deletetest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class Contact2Abstract extends TopiaEntityAbstract implements Contact2 {

    public String contactValue;
    public String type;
    public Collection<Party2> party2;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Contact2.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Contact2.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "contactValue", String.class, contactValue);
        visitor.visit(this, "type", String.class, type);
        visitor.visit(this, "party2", Collection.class, Party2.class, party2);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setContactValue :
     * @param value 
     */

    public void setContactValue(String value) {
        String _oldValue = this.contactValue;
        fireOnPreWrite("contactValue", _oldValue, value);
        this.contactValue = value;
        fireOnPostWrite("contactValue", _oldValue, value);
}

    /**
     * getContactValue :
     * @return String 
     */

    public String getContactValue() {
        fireOnPreRead("contactValue", contactValue);
        String result = this.contactValue;
        fireOnPostRead("contactValue", contactValue);
        return result;
}

    /**
     * setType :
     * @param value 
     */

    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        fireOnPostWrite("type", _oldValue, value);
}

    /**
     * getType :
     * @return String 
     */

    public String getType() {
        fireOnPreRead("type", type);
        String result = this.type;
        fireOnPostRead("type", type);
        return result;
}

    /**
     * addParty2 :
     * @param party2 
     */

    public void addParty2(Party2 party2) {    
        fireOnPreWrite("party2", null, party2);
        if (this.party2 == null) {
            this.party2 = new ArrayList<Party2>();
        }
        if (party2.getContacts() == null) {
            party2.setContacts(new ArrayList<Contact2>());
        }
        party2.getContacts().add(this);
        this.party2.add(party2);
        fireOnPostWrite("party2", this.party2.size(), null, party2);
}

    /**
     * addAllParty2 :
     * @param values 
     */

    public void addAllParty2(Collection<Party2> values) {
        if (values == null) {
            return;
        }
        for (Party2 item : values) {
            addParty2(item);
        }
}

    /**
     * getParty2ByTopiaId :
     * @param topiaId 
     * @return Party2 
     */

    public Party2 getParty2ByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(party2, topiaId);
 }

    /**
     * setParty2 :
     * @param values 
     */

    public void setParty2(Collection<Party2> values) {
        Collection<Party2> _oldValue = party2;
        fireOnPreWrite("party2", _oldValue, values);
        party2 = values;
        fireOnPostWrite("party2", _oldValue, values);
}

    /**
     * removeParty2 :
     * @param value 
     */

    public void removeParty2(Party2 value) {
        fireOnPreWrite("party2", value, null);
        if ((this.party2 == null) || (!this.party2.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.getContacts().remove(this);
        fireOnPostWrite("party2", this.party2.size()+1, value, null);
}

    /**
     * clearParty2 :
     */

    public void clearParty2() {
        if (this.party2 == null) {
            return;
        }
        for (Party2 item : this.party2) {
            item.getContacts().remove(this);
        }
        Collection<Party2> _oldValue = new ArrayList<Party2>(this.party2);
        fireOnPreWrite("party2", _oldValue, this.party2);
        this.party2.clear();
        fireOnPostWrite("party2", _oldValue, this.party2);
}

    /**
     * getParty2 :
     * @return Collection<Party2> 
     */

    public Collection<Party2> getParty2() {
        return party2;
}

    /**
     * sizeParty2 :
     * @return int 
     */

    public int sizeParty2() {
        if (party2 == null) {
            return 0;
        }
        return party2.size();
}

    /**
     * isParty2Empty :
     * @return boolean 
     */

    public boolean isParty2Empty() {
        int size = sizeParty2();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("contactValue", this.contactValue).
            append("type", this.type).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.contact2");
    org.nuiton.i18n.I18n.n_("topia.test.common.contactValue");
    org.nuiton.i18n.I18n.n_("topia.test.common.type");
    org.nuiton.i18n.I18n.n_("topia.test.common.party2");
    }

} //Contact2Abstract
