package org.nuiton.topia.it.legacy.topiatest.deletetest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.it.legacy.AbstractTopiaItLegacyDao;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

public abstract class GeneratedContact2TopiaDao<E extends Contact2> extends AbstractTopiaItLegacyDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Contact2.class;
    }

    @Override
    public TopiaItLegacyEntityEnum getTopiaEntityEnum() {
        return TopiaItLegacyEntityEnum.Contact2;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();

        {
            String sql = "SELECT main.* " +
                    " FROM party2 main, contacts_party2 secondary " +
                    " WHERE main.topiaId=secondary.party2 " +
                    " AND secondary.contacts='" + entity.getTopiaId() + "'";
            List<Party2> list = hibernateSupport.getHibernateSession()
                    .createNativeQuery(sql)
                    .addEntity("main", TopiaItLegacyEntityEnum.Party2.getImplementation())
                    .list();

            for (Party2 item : list) {
                item.removeContacts(entity);
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContactValueIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Contact2.PROPERTY_CONTACT_VALUE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContactValueEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Contact2.PROPERTY_CONTACT_VALUE, v);
        return result;
    }

    @Deprecated
    public E findByContactValue(String v) {
        return forContactValueEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContactValue(String v) {
        return forContactValueEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Contact2.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Contact2.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(String v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(String v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParty2Contains(Party2 v) {
        return forContains(Contact2.PROPERTY_PARTY2, v);
    }

    @Deprecated
    public E findContainsParty2(Party2 v) {
        return forParty2Contains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsParty2(Party2 v) {
        return forParty2Contains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Party2.class) {
            Party2TopiaDao dao =
                topiaDaoSupplier.getDao(Party2.class, Party2TopiaDao.class);
            tmp = dao.forContactsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Party2.class, entity);
        if (!list.isEmpty()) {
            result.put(Party2.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedContact2TopiaDao<E extends Contact2>
