/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.scmwebeditor.uiweb.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.scmwebeditor.api.ScmConnection;
import org.nuiton.scmwebeditor.api.ScmProvider;
import org.nuiton.scmwebeditor.uiweb.ScmWebEditorConfig;
import org.nuiton.scmwebeditor.uiweb.actions.ScmWebEditorMainAction;

public class DownloadFileAction
extends ScmWebEditorMainAction {
    private static final Log log = LogFactory.getLog(DownloadFileAction.class);
    protected String repositoryRoot;

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public String execute() {
        HttpSession session = this.request.getSession();
        String sessionId = session.getId();
        String pathToLocalRepos = ScmWebEditorConfig.getLocalRepositoriesPath() + File.separator + sessionId;
        ScmProvider provider = ScmWebEditorConfig.getProvider((String)this.scmType);
        ScmConnection scmConn = provider.getConnection(this.address, pathToLocalRepos);
        String repositoryUUID = scmConn.getRepositoryId();
        if (repositoryUUID == null) {
            repositoryUUID = this.address.replace(' ', '_');
            repositoryUUID = Normalizer.normalize(repositoryUUID, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
        }
        String[] usernamePw = this.getUsernamePwFromSession(repositoryUUID, this.username, this.pw);
        this.username = usernamePw[0];
        this.pw = usernamePw[1];
        String filePath = scmConn.getFilePath(this.address, this.repositoryRoot, this.username, this.pw);
        String filename = filePath.substring(filePath.lastIndexOf(47) + 1);
        File fileToDownload = new File(filePath);
        if (fileToDownload.exists()) {
            this.response.setContentType("application/octet-stream");
            String disHeader = "Attachment; Filename=\"" + filename + "\"";
            this.response.setHeader("Content-Disposition", disHeader);
            try {
                ServletOutputStream outs = this.response.getOutputStream();
                FileInputStream fis = new FileInputStream(fileToDownload);
                BufferedInputStream in = new BufferedInputStream(fis);
                int ch = 0;
                while (ch != -1) {
                    ch = ((InputStream)in).read();
                    outs.print((char)ch);
                }
                outs.flush();
                outs.close();
                ((InputStream)in).close();
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Can not read file " + fileToDownload), (Throwable)e);
                }
            }
        } else {
            return "error";
        }
        return "success";
    }
}

