/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.nuiton.i18n.I18n;
import org.nuiton.log.LutinLog;
import org.nuiton.log.LutinLogEvent;
import org.nuiton.log.LutinLogFactory;
import org.nuiton.log.LutinLogListener;
import org.nuiton.log.LutinProgressEvent;

@Deprecated
public class StatusBar
extends JPanel
implements LutinLogListener,
ActionListener {
    private static final long serialVersionUID = 5726270382079837021L;
    protected static final String EMPTY_STATUS = " ";
    protected Box box = null;
    protected Color statusForeground = null;
    protected JLabel statusLabel = null;
    protected String statusReferenceContent = null;
    protected Timer timer = null;
    protected final Object john = new Object();

    public StatusBar() {
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.fadeStatus();
    }

    public void clearStatus() {
        this.stopStatusFader();
        this.getStatusLabel().setText(EMPTY_STATUS);
    }

    protected void fadeStatus() {
        for (int i = 0; i < 8; ++i) {
            if (!this.statusReferenceContent.equals(this.getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = this.getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(), currentForeground.getGreen(), currentForeground.getBlue(), currentForeground.getAlpha() - 25);
            this.getStatusLabel().setForeground(newColor);
            this.getStatusLabel().repaint();
        }
    }

    protected JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(EMPTY_STATUS);
        }
        return this.statusLabel;
    }

    protected void initialize() {
        this.initializeUI();
        this.statusForeground = this.getStatusLabel().getForeground();
    }

    protected void initializeUI() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getStatusLabel(), gridBagConstraints3);
        this.box = new Box(0);
        this.add(this.box);
        this.box.add(new MemoryStatus());
        this.box.add(new Clock());
    }

    public void listen(LutinLogFactory factory) {
        factory.addLutinLogListener((LutinLogListener)this);
    }

    public void listen(LutinLog log) {
        log.addLutinLogListener((LutinLogListener)this);
    }

    public void logEvent(LutinLogEvent e) {
        if (e.getMsg() != null) {
            this.setStatus(e.getMsg());
        }
    }

    public void progressEvent(LutinProgressEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        StatusBar sb = new StatusBar();
        frame.setSize(800, 50);
        frame.getContentPane().add(sb);
        frame.setDefaultCloseOperation(3);
        sb.setStatus("StatusBar test");
        frame.setVisible(true);
    }

    public void setStatus(String status) {
        this.stopStatusFader();
        this.getStatusLabel().setText(status);
        this.startStatusFader();
    }

    protected void startStatusFader() {
        this.statusReferenceContent = this.getStatusLabel().getText();
        int millisecondsPerMinute = 5000;
        this.timer = new Timer(millisecondsPerMinute, this);
        this.timer.setRepeats(false);
        this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
        this.timer.start();
    }

    protected void stopStatusFader() {
        if (this.timer != null) {
            this.timer.stop();
            this.getStatusLabel().setForeground(this.statusForeground);
        }
    }

    class MemoryStatus
    extends JComponent
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private LineMetrics lm;
        private static final String memoryTestStr = "99999/99999Mb";
        private Color progressBackground;
        private Color progressForeground;
        private Timer timer;

        public MemoryStatus() {
            Font font = new JLabel().getFont();
            this.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = font.getStringBounds(memoryTestStr, frc);
            Dimension dim = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
            this.lm = font.getLineMetrics(memoryTestStr, frc);
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.progressForeground = Color.decode("#cccccc");
            this.progressBackground = Color.decode("#666699a");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.repaint();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom - 1;
            float fraction = (float)usedMemory / (float)totalMemory;
            g.setColor(this.progressBackground);
            g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
            String str = I18n._((String)"lutinwidget.message.statusbar.memory", (Object[])new Object[]{usedMemory / 1024, totalMemory / 1024});
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
            Graphics g2 = g.create();
            g2.setClip(insets.left, insets.top, (int)((float)width * fraction), height);
            g2.setColor(this.progressForeground);
            g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
            g2 = g.create();
            g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), height);
            g2.setColor(this.getForeground());
            g2.drawString(str, insets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)insets.top + this.lm.getAscent()));
            g2.dispose();
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            super.removeNotify();
        }
    }

    class Clock
    extends JLabel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private Timer timer;

        public Clock() {
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.update();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.update();
            int millisecondsPerMinute = 60000;
            this.timer = new Timer(millisecondsPerMinute, this);
            this.timer.setInitialDelay((int)((long)millisecondsPerMinute - System.currentTimeMillis() % (long)millisecondsPerMinute) + 500);
            this.timer.start();
        }

        private String getTime() {
            return DateFormat.getTimeInstance(3).format(new Date());
        }

        @Override
        public void removeNotify() {
            this.timer.stop();
            super.removeNotify();
        }

        private void update() {
            this.setText(this.getTime());
        }
    }
}

