/* *##% Graphical Widget
 * Copyright (C) 2004 - 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * DefaultEditor.java
 *
 * Created: 6 août 2006 13:03:46
 *
 * @author poussin
 * @version $Revision: 215 $
 *
 * Last update: $Date: 2009-07-15 15:57:23 +0200 (mer., 15 juil. 2009) $
 * by : $Author: echatellier $
 */

package org.nuiton.widget.editor;

import java.awt.BorderLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Default editor, can open of kind of file
 * 
 * behaviour: <li>undo/redo (Ctrl-z, Shift-Ctrl-z) <li>Scrollbar
 * 
 * @author poussin
 * 
 */
public class DefaultEditor extends JPanel implements EditorInterface,
        DocumentListener {

    /** serialVersionUID */
    private static final long serialVersionUID = 5049495816540748017L;

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(DefaultEditor.class);

    protected JEditorPane editor = new JEditorPane();
    protected JScrollPane scrollPane = new JScrollPane(editor);
    protected boolean isModified = false;

    public DefaultEditor() {
        setLayout(new BorderLayout());
        add(scrollPane, BorderLayout.CENTER);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.codelutin.widget.editor.EditorInterface#addDocumentListener(javax
     * .swing.event.DocumentListener)
     */
    public void addDocumentListener(DocumentListener listener) {
        editor.getDocument().addDocumentListener(listener);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.codelutin.widget.editor.EditorInterface#removeDocumentListener(javax
     * .swing.event.DocumentListener)
     */
    public void removeDocumentListener(DocumentListener listener) {
        editor.getDocument().removeDocumentListener(listener);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.codelutin.widget.editor.EditorInterface#accept(java.io.File)
     */
    public boolean accept(File file) {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.codelutin.widget.editor.EditorInterface#isModified()
     */
    public boolean isModified() {
        return isModified;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.codelutin.widget.Editor#open(java.io.File)
     */
    public boolean open(File file) {
        try {
            Document doc = editor.getDocument();
            EditorHelper.removeUndoRedoSupport(editor);
            doc.removeDocumentListener(this);
            Reader in = new BufferedReader(new FileReader(file));
            editor.read(in, file);
            doc = editor.getDocument();
            doc.addDocumentListener(this);
            EditorHelper.addUndoRedoSupport(editor);
            isModified = false;
            return true;
        } catch (FileNotFoundException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Can't find file: " + file, eee);
            }
        } catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Can't open file: " + file, eee);
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.codelutin.widget.Editor#saveAs(java.io.File)
     */
    public boolean saveAs(File file) {
        try {
            FileOutputStream outf = new FileOutputStream(file);
            Writer out = new OutputStreamWriter(outf, "utf-8");
            editor.write(out);
            isModified = false;
            return true;
        } catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Can't save file", eee);
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.codelutin.widget.editor.EditorInterface#getText()
     */
    public String getText() {
        String result = editor.getText();
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.codelutin.widget.editor.EditorInterface#setText(java.lang.String)
     */
    public void setText(String text) {
        editor.setText(text);
    }

    /*
     * (non-Javadoc)
     * 
     * @seejavax.swing.event.DocumentListener#insertUpdate(javax.swing.event.
     * DocumentEvent)
     */
    public void insertUpdate(DocumentEvent e) {
        isModified = true;
    }

    /*
     * (non-Javadoc)
     * 
     * @seejavax.swing.event.DocumentListener#removeUpdate(javax.swing.event.
     * DocumentEvent)
     */
    public void removeUpdate(DocumentEvent e) {
        isModified = true;
    }

    /*
     * (non-Javadoc)
     * 
     * @seejavax.swing.event.DocumentListener#changedUpdate(javax.swing.event.
     * DocumentEvent)
     */
    public void changedUpdate(DocumentEvent e) {
        isModified = true;
    }

}
