/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.pagination;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.nuiton.util.pagination.PaginationOrder;

public class PaginationParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int pageNumber;
    protected int pageSize;
    protected List<PaginationOrder> orderClauses;

    protected PaginationParameter(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, new LinkedList<PaginationOrder>());
    }

    protected PaginationParameter(int pageNumber, int pageSize, List<PaginationOrder> orderClauses) {
        Preconditions.checkArgument(pageNumber >= 0, "pageNumber cannot be lower than 0");
        Preconditions.checkArgument(pageSize == -1 || pageSize > 0, "pageSize can only be -1 or greater than 0");
        Preconditions.checkArgument(pageSize != -1 || pageNumber == 0, "This is non-sense to have pageNumber>1 if pageSize==-1");
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.orderClauses = Collections.unmodifiableList(orderClauses);
    }

    public static PaginationParameter of(int pageNumber, int pageSize) {
        PaginationParameter result = new PaginationParameter(pageNumber, pageSize);
        return result;
    }

    public static PaginationParameter of(int pageNumber, int pageSize, String orderClause1, boolean orderDesc1) {
        return PaginationParameter.builder(pageNumber, pageSize).addOrder(orderClause1, orderDesc1).build();
    }

    public static PaginationParameter of(int pageNumber, int pageSize, String orderClause1, boolean orderDesc1, String orderClause2, boolean orderDesc2) {
        return PaginationParameter.builder(pageNumber, pageSize).addOrder(orderClause1, orderDesc1).addOrder(orderClause2, orderDesc2).build();
    }

    public static PaginationParameter of(int pageNumber, int pageSize, String orderClause1, boolean orderDesc1, String orderClause2, boolean orderDesc2, String orderClause3, boolean orderDesc3) {
        return PaginationParameter.builder(pageNumber, pageSize).addOrder(orderClause1, orderDesc1).addOrder(orderClause2, orderDesc2).addOrder(orderClause3, orderDesc3).build();
    }

    public static PaginationParameterBuilder builder(int pageNumber, int pageSize) {
        PaginationParameterBuilder result = new PaginationParameterBuilder(pageNumber, pageSize);
        return result;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<PaginationOrder> getOrderClauses() {
        return this.orderClauses;
    }

    public int getStartIndex() {
        if (this.pageNumber != 0) {
            Preconditions.checkState(this.pageSize != -1, "This is non-sense to have pageNumber>1 if pageSize==-1");
        }
        int startIndex = this.pageNumber * this.pageSize;
        return startIndex;
    }

    public int getEndIndex() {
        int endIndex = Integer.MAX_VALUE;
        if (this.pageSize != -1) {
            endIndex = this.getStartIndex() + this.pageSize - 1;
        }
        return endIndex;
    }

    public static class PaginationParameterBuilder {
        protected int pageNumber;
        protected int pageSize;
        protected List<PaginationOrder> orderClauses;

        public PaginationParameterBuilder(int pageNumber, int pageSize) {
            this.pageNumber = pageNumber;
            this.pageSize = pageSize;
        }

        public PaginationParameterBuilder addOrder(String clause, boolean desc) {
            if (this.orderClauses == null) {
                this.orderClauses = Lists.newLinkedList();
            }
            PaginationOrder paginationOrder = new PaginationOrder(clause, desc);
            this.orderClauses.add(paginationOrder);
            return this;
        }

        public PaginationParameterBuilder addAscOrder(String clause) {
            return this.addOrder(clause, false);
        }

        public PaginationParameterBuilder addDescOrder(String clause) {
            return this.addOrder(clause, true);
        }

        public PaginationParameterBuilder addOrder(String clause) {
            boolean desc = false;
            String cleanedClause = clause;
            int spaceIndex = clause.indexOf(32);
            if (spaceIndex != -1) {
                cleanedClause = clause.substring(0, spaceIndex).trim();
                desc = "desc".equalsIgnoreCase(clause.substring(spaceIndex + 1).trim());
            }
            return this.addOrder(cleanedClause, desc);
        }

        public PaginationParameterBuilder addOrderClauses(Iterable<PaginationOrder> clauses) {
            if (this.orderClauses == null) {
                this.orderClauses = Lists.newLinkedList();
            }
            if (clauses != null) {
                Iterables.addAll(this.orderClauses, clauses);
            }
            return this;
        }

        public PaginationParameter build() {
            PaginationParameter result = new PaginationParameter(this.pageNumber, this.pageSize, this.orderClauses);
            return result;
        }
    }
}

