/*
 * #%L
 * Nuiton Utils :: Nuiton Utils
 * 
 * $Id: MultiJXPathDecorator.java 2162 2011-08-04 12:48:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.4.5/nuiton-utils/src/main/java/org/nuiton/util/decorator/MultiJXPathDecorator.java $
 * %%
 * Copyright (C) 2011 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.decorator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Comparator;

/**
 * {@link JXPathDecorator} implementation with multiple contexts.
 *
 * @param <O> type of data to decorate
 * @author tchemit <chemit@codelutin.com>
 * @see Decorator
 * @since 2.3
 */
public class MultiJXPathDecorator<O> extends JXPathDecorator<O> {

    private static final long serialVersionUID = 1L;

    /** Logger */
    private static final Log log =
            LogFactory.getLog(MultiJXPathDecorator.class);

    /** Contexts of the decorator */
    protected Context<O>[] contexts;

    /** context separator */
    protected String separator;

    /** context separator replacement */
    protected String separatorReplacement;

    protected MultiJXPathDecorator(
            Class<O> internalClass,
            String expression,
            String separator,
            String separatorReplacement,
            Context<O>[] contexts) throws IllegalArgumentException,
            NullPointerException {
        super(internalClass, expression, null);
        this.separator = separator;
        this.separatorReplacement = separatorReplacement;
        this.contexts = contexts;

        setContextIndex(0);

        if (log.isDebugEnabled()) {
            log.debug(expression + " --> " + context);
        }
    }

    protected MultiJXPathDecorator(
            Class<O> internalClass,
            String expression,
            String separator,
            String separatorReplacement) throws IllegalArgumentException,
            NullPointerException {
        this(internalClass,
             expression,
             separator,
             separatorReplacement,
             DecoratorUtil.<O>createMultiJXPathContext(expression,
                                                       separator,
                                                       separatorReplacement)
        );
    }

    public void setContextIndex(int index) {
        ensureContextIndex(this, index);
        setContext(contexts[index]);
    }

    public int getNbContext() {
        return contexts.length;
    }

    public String getSeparator() {
        return separator;
    }

    public String getSeparatorReplacement() {
        return separatorReplacement;
    }

    @Override
    protected Comparator<O> getComparator(int pos) {
        ensureContextIndex(this, pos);
        Context<O> context1 = contexts[pos];
        return context1.getComparator(0);
    }

    protected void ensureContextIndex(MultiJXPathDecorator<?> decorator,
                                      int pos) {
        if (pos < -1 || pos > decorator.contexts.length) {
            throw new ArrayIndexOutOfBoundsException(
                    "context index " + pos +
                    " is out of bound, can be inside [" + 0 + "," +
                    decorator.contexts.length + "]");
        }
    }
}
