/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueGetterSetter;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.util.StringUtil;

public class Common {
    public static final ValueParserFormatter<String> STRING = new StringValueParser();
    public static final ValueFormatter<?> TO_STRING_FORMATTER = new ToStringValueFormatter();
    public static final ValueParserFormatter<Boolean> BOOLEAN = new BooleanParserFormatter(null, true);
    public static final ValueParserFormatter<Boolean> PRIMITIVE_BOOLEAN = new BooleanParserFormatter(false, false);
    public static ValueParserFormatter<Character> CHAR = new CharacterParserFormatter(null, true);
    public static ValueParserFormatter<Short> PRIMITIVE_SHORT = new ShortParserFormatter((short)0, false);
    public static ValueParserFormatter<Short> SHORT = new ShortParserFormatter(null, true);
    public static ValueParserFormatter<Integer> INTEGER = new IntegerParserFormatter(null, true);
    public static ValueParserFormatter<Integer> PRIMITIVE_INTEGER = new IntegerParserFormatter(0, false);
    public static ValueParserFormatter<Long> LONG = new LongParserFormatter(null, true);
    public static ValueParserFormatter<Long> PRIMITIVE_LONG = new LongParserFormatter(0L, false);
    public static ValueParserFormatter<Float> FLOAT = new FloatParserFormatter(null, true);
    public static ValueParserFormatter<Float> PRIMITIVE_FLOAT = new FloatParserFormatter(Float.valueOf(0.0f), false);
    public static ValueParserFormatter<Double> DOUBLE = new DoubleParserFormatter(null, true);
    public static ValueParserFormatter<Double> DOUBLE_PRIMITIVE = new DoubleParserFormatter(0.0, false);
    public static final ValueParserFormatter<Date> DAY = new DateValue("dd/MM/yyyy");
    public static final ValueParserFormatter<Date> DAY_TIME = new DateValue("dd/MM/yyyy HH:mm");
    public static final ValueParserFormatter<Date> DAY_TIME_SECOND = new DateValue("dd/MM/yyyy HH:mm:ss");
    public static final ValueParserFormatter<Date> TIME = new DateValue("HH:mm");
    public static final ValueParserFormatter<Date> WEEK = new DateValue("w/yyyy");
    public static final ValueParserFormatter<Date> YEAR = new DateValue("yyyy");

    public static <E extends Map<String, Object>, T> MapProperty<E, T> newMapProperty(String propertyName) {
        return new MapProperty(propertyName);
    }

    public static <E, T> BeanProperty<E, T> newBeanProperty(String propertyName) {
        return new BeanProperty(propertyName);
    }

    public static <E extends Enum<E>> ValueParserFormatter<E> newEnumByNameParserFormatter(Class<E> enumType) {
        return new EnumByNameParserFormatter<E>(enumType);
    }

    public static <E> ValueParserFormatter<List<E>> newListParserFormatter(char separator, ValueParserFormatter<E> valueParserFormatter, List<E> defaultValue, boolean nullAllowed) {
        return new ListValueParser<E>(separator, valueParserFormatter, defaultValue, nullAllowed);
    }

    public static <E extends Enum<E>> ValueParserFormatter<E> newEnumByOrdinalParserFormatter(Class<E> enumType) {
        return new EnumByOrdinalParserFormatter<E>(enumType);
    }

    public static class DoubleParserFormatter
    extends NullableParserFormatter<Double> {
        public DoubleParserFormatter(Double defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Double value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Double parseNoneEmptyValue(String value) {
            return Double.valueOf(value);
        }
    }

    public static class FloatParserFormatter
    extends NullableParserFormatter<Float> {
        public FloatParserFormatter(Float defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Float value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Float parseNoneEmptyValue(String value) {
            return Float.valueOf(value);
        }
    }

    public static class LongParserFormatter
    extends NullableParserFormatter<Long> {
        public LongParserFormatter(Long defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Long value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Long parseNoneEmptyValue(String value) {
            Double aDouble = Double.valueOf(value);
            if (aDouble > 9.223372036854776E18) {
                throw new IllegalArgumentException(value + " is too big to be an long.");
            }
            return aDouble.longValue();
        }
    }

    public static class IntegerParserFormatter
    extends NullableParserFormatter<Integer> {
        public IntegerParserFormatter(Integer defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Integer value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Integer parseNoneEmptyValue(String value) {
            Float aFloat = Float.valueOf(value);
            if (aFloat.floatValue() > 2.1474836E9f) {
                throw new IllegalArgumentException(value + " is too big to be an int, should be a long.");
            }
            return aFloat.intValue();
        }
    }

    public static class ShortParserFormatter
    extends NullableParserFormatter<Short> {
        public ShortParserFormatter(Short defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Short value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Short parseNoneEmptyValue(String value) {
            Float aFloat = Float.valueOf(value);
            if (aFloat.floatValue() > 32767.0f) {
                throw new IllegalArgumentException(value + " is too big to be an short, should be a integer.");
            }
            return aFloat.shortValue();
        }
    }

    public static class CharacterParserFormatter
    extends NullableParserFormatter<Character> {
        public CharacterParserFormatter(Character defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        @Override
        public String format(Character value) {
            String str = "";
            if (value != null) {
                str = String.valueOf(value);
            }
            return str;
        }

        @Override
        protected Character parseNoneEmptyValue(String value) {
            return Character.valueOf(value.charAt(0));
        }
    }

    public static class BooleanParserFormatter
    extends NullableParserFormatter<Boolean> {
        public BooleanParserFormatter(Boolean defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String format(Boolean bool) {
            if (bool == null) {
                if (!this.nullAllowed) throw new IllegalArgumentException();
                return "?";
            }
            if (bool == false) return "N";
            return "Y";
        }

        @Override
        protected Boolean parseNoneEmptyValue(String value) {
            Boolean result = "?".equals(value) ? null : ("Y".equals(value) ? Boolean.valueOf(true) : ("N".equals(value) ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(value))));
            return result;
        }
    }

    public static abstract class NullableParserFormatter<O>
    implements ValueParserFormatter<O> {
        protected O defaultValue;
        protected boolean nullAllowed;

        protected abstract O parseNoneEmptyValue(String var1) throws ParseException;

        protected NullableParserFormatter(O defaultValue, boolean nullAllowed) {
            this.defaultValue = defaultValue;
            this.nullAllowed = nullAllowed;
        }

        @Override
        public O parse(String value) throws ParseException {
            O result = StringUtils.isBlank((CharSequence)value) ? this.defaultValue : this.parseNoneEmptyValue(value);
            if (result == null && !this.nullAllowed) {
                throw new IllegalArgumentException();
            }
            return result;
        }
    }

    public static class ListValueParser<E>
    extends NullableParserFormatter<List<E>> {
        protected ValueParserFormatter<E> valueParserFormater;
        protected Splitter splitter;
        protected Joiner joiner;

        public ListValueParser(char separator, ValueParserFormatter<E> valueParserFormatter, List<E> defaultValue, boolean nullAllowed) {
            super(defaultValue, nullAllowed);
            this.valueParserFormater = valueParserFormatter;
            this.splitter = Splitter.on((char)separator);
            this.joiner = Joiner.on((char)separator);
        }

        @Override
        protected List<E> parseNoneEmptyValue(String value) throws ParseException {
            Iterable values = this.splitter.split((CharSequence)value);
            ArrayList result = Lists.newArrayList();
            for (String soloValue : values) {
                Object data = this.valueParserFormater.parse(soloValue);
                result.add(data);
            }
            return result;
        }

        @Override
        public String format(List<E> values) {
            String result = null;
            if (values != null) {
                result = this.joiner.join((Iterable)Lists.transform(values, (Function)new Function<E, String>(){

                    public String apply(E e) {
                        return valueParserFormater.format(e);
                    }
                }));
            }
            return result;
        }
    }

    public static class ValueSaver<E, T>
    implements ValueGetterSetter<E, T> {
        protected T value;

        @Override
        public T get(E object) throws Exception {
            return this.value;
        }

        @Override
        public void set(E object, T value) throws Exception {
            this.value = value;
        }
    }

    public static class ToStringParserFormatter<E>
    implements ValueParserFormatter<E> {
        protected Map<E, String> toStrings = new HashMap<E, String>();
        protected Map<String, E> fromString = new HashMap<String, E>();

        public ToStringParserFormatter(List<E> values) {
            this(values, null);
        }

        public ToStringParserFormatter(E[] values) {
            this.computeToStrings(values, null);
        }

        public ToStringParserFormatter(List<E> values, StringUtil.ToString<E> toString) {
            this.computeToStrings(values, toString);
        }

        protected void computeToStrings(E[] values, StringUtil.ToString<E> toString) {
            LinkedList valuesAsList = new LinkedList();
            Collections.addAll(valuesAsList, values);
            this.computeToStrings(valuesAsList, toString);
        }

        protected void computeToStrings(List<E> values, StringUtil.ToString<E> toString) {
            for (E value : values) {
                String valueToString = toString == null ? value.toString() : toString.toString(value);
                this.toStrings.put(value, valueToString);
                this.fromString.put(valueToString, value);
            }
        }

        @Override
        public String format(E value) {
            String valueAsString = this.toStrings.get(value);
            if (valueAsString == null) {
                throw new IllegalArgumentException();
            }
            return valueAsString;
        }

        @Override
        public E parse(String valueAsString) throws ParseException {
            E value = this.fromString.get(valueAsString);
            if (value == null) {
                throw new IllegalArgumentException("Unable to parse value '" + valueAsString + "'. Possible values are " + this.fromString.keySet().toString());
            }
            return value;
        }
    }

    public static class EnumByOrdinalParserFormatter<E extends Enum<E>>
    implements ValueParserFormatter<E> {
        private final E[] universe;
        private final int maxValue;

        public EnumByOrdinalParserFormatter(Class<E> enumType) {
            this.universe = (Enum[])enumType.getEnumConstants();
            this.maxValue = this.universe.length - 1;
        }

        @Override
        public E parse(String value) throws ParseException {
            E result;
            if (StringUtils.isBlank((CharSequence)value)) {
                result = null;
            } else {
                Integer ordinal;
                try {
                    ordinal = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Could not parse ordinal value [" + value + "]", 0);
                }
                if (ordinal > this.maxValue) {
                    throw new ParseException("Ordinal value [" + ordinal + "] not inbound (possible value from [0.." + this.maxValue + "] for enum " + Arrays.toString(this.universe), 0);
                }
                result = this.universe[ordinal];
            }
            return result;
        }

        @Override
        public String format(E date) {
            String value = "";
            if (date != null) {
                value = ((Enum)date).name();
            }
            return value;
        }
    }

    public static class EnumByNameParserFormatter<E extends Enum<E>>
    implements ValueParserFormatter<E> {
        private final Class<E> enumType;

        public EnumByNameParserFormatter(Class<E> enumType) {
            this.enumType = enumType;
        }

        @Override
        public E parse(String value) throws ParseException {
            E result = StringUtils.isBlank((CharSequence)value) ? null : (E)Enum.valueOf(this.enumType, value);
            return result;
        }

        @Override
        public String format(E date) {
            String value = "";
            if (date != null) {
                value = ((Enum)date).name();
            }
            return value;
        }
    }

    public static class DateValue
    implements ValueParserFormatter<Date> {
        protected String dateFormatPattern;
        protected DateFormat dateFormat;

        public DateValue(String dateFormatPattern) {
            this.dateFormatPattern = dateFormatPattern;
            this.dateFormat = new SimpleDateFormat(dateFormatPattern);
        }

        @Override
        public Date parse(String value) throws ParseException {
            Date date = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    date = this.dateFormat.parse(value);
                }
                catch (ParseException e) {
                    throw new ParseException("unable to parse date, expected format is " + this.dateFormatPattern, 0);
                }
            }
            return date;
        }

        @Override
        public String format(Date date) {
            String value = "";
            if (date != null) {
                value = this.dateFormat.format(date);
            }
            return value;
        }
    }

    public static class MapProperty<E extends Map<String, Object>, T>
    implements ValueGetterSetter<E, T> {
        protected String propertyName;

        MapProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void set(E bean, T value) throws Exception {
            bean.put((String)this.propertyName, value);
        }

        @Override
        public T get(E object) throws Exception {
            Object value = object.get(this.propertyName);
            return (T)value;
        }
    }

    public static class BeanProperty<E, T>
    implements ValueGetterSetter<E, T> {
        protected String propertyName;

        BeanProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void set(E bean, T value) throws Exception {
            BeanUtilsBean.getInstance().getPropertyUtils().setProperty(bean, this.propertyName, value);
        }

        @Override
        public T get(E object) throws Exception {
            Object value = PropertyUtils.getProperty(object, (String)this.propertyName);
            return (T)value;
        }
    }

    public static class ToStringValueFormatter
    implements ValueFormatter<Object> {
        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }
    }

    public static class StringValueParser
    implements ValueParserFormatter<String> {
        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public String format(String value) {
            return value == null ? "" : value;
        }
    }
}

