/*
 * *##% 
 * JRedmine :: Maven plugin
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.plugin.announcement;

/**
 * Generate the content of the release email announcement.
 *
 * @author tchemit
 * @goal generate-email-announcement
 * @since 1.0.0
 */
public class GenerateEmailAnnouncementMojo extends AbstractAnnouncementMojo {

    /**
     * The Velocity template used to format the release email announcement.
     *
     * @parameter expression="${redmine.emailAnnouncementTemplate}" default-value="release-email-announcement.vm"
     * @required
     * @since 1.0.0
     */
    protected String emailAnnouncementTemplate;
    /**
     * A flag to enable or disable the goal.
     *
     * @parameter expression="${changes.skipGenerateEmailAnnouncement}" default-value="false"
     * @since 1.0.0
     */
    protected boolean skipGenerateEmailAnnouncement;

    @Override
    protected String getAnnouncementTemplate() {
        return emailAnnouncementTemplate;
    }

    @Override
    protected boolean isGoalSkip() {
        return skipGenerateEmailAnnouncement;
    }
}
