/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: DefaultRedmineAnonymousService.java 186 2011-05-20 12:32:08Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2/jredmine-client/src/main/java/org/nuiton/jredmine/DefaultRedmineAnonymousService.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.model.*;
import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 * Default implementation of {@link RedmineAnonymousService}.
 * <p/>
 * This implementation just make sure that the rest client is anonnymous.
 * <p/>
 * Created: 2 janv. 2010
 *
 * @author chemit
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 186 $
 *          <p/>
 *          Mise a jour: $Date: 2011-05-20 14:32:08 +0200 (Fri, 20 May 2011) $ par :
 *          $Author: tchemit $
 * @plexus.component role="org.nuiton.jredmine.RedmineAnonymousService" role-hint="default"
 * @see org.nuiton.io.rest.RestClientConfiguration#isAnonymous()
 * @since 1.0.3
 */
public class DefaultRedmineAnonymousService implements RedmineServiceImplementor, RedmineAnonymousService {
    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(DefaultRedmineAnonymousService.class);
    //FIXME Make this works again (there is a bad internal state somewhere...)
//    /**
//     * @plexus.requirement role="org.nuiton.jredmine.RedmineServiceImplementor" role-hint="default"
//     */
    protected RedmineServiceImplementor delegateImplementor;

    public DefaultRedmineAnonymousService() {
        delegateImplementor = new DefaultRedmineServiceImplementor();
    }

    ///////////////////////////////////////////////////////////////////////////
    /// RedmineAnonymousService implementation
    ///////////////////////////////////////////////////////////////////////////

    @Override
    public IssueStatus[] getIssueStatuses() throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ISSUE_STATUS_LIST, IssueStatus.class);
    }

    @Override
    public IssuePriority[] getIssuePriorities() throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ISSUE_PRIORITY_LIST, IssuePriority.class);
    }

    @Override
    public Project[] getProjects() throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_PROJECT_LIST, Project.class);
    }

    @Override
    public IssueCategory[] getIssueCategories(String projectName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ISSUE_CATEGORY_LIST, IssueCategory.class, projectName);
    }

    @Override
    public Project getProject(String projectName) throws RedmineServiceException {
        return getData(RedmineRestClient.GET_PROJECT, Project.class, projectName);
    }

    @Override
    public Tracker[] getTrackers(String projectName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_TRACKER_LIST, Tracker.class, projectName);
    }

    @Override
    public News[] getNews(String projectName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_NEWS_LIST, News.class, projectName);
    }

    @Override
    public User[] getUsers(String projectName) throws RedmineServiceException {
        return getProjectMembers(projectName);
    }

    @Override
    public User[] getProjectMembers(String projectName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_USER_LIST, User.class, projectName);
    }

    @Override
    public Version[] getVersions(String projectName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_VERSION_LIST, Version.class, projectName);
    }

    @Override
    public Version getVersion(String projectName, String versionName) throws RedmineServiceException {
        return getData(RedmineRestClient.GET_VERSION, Version.class, projectName, versionName);
    }

    @Override
    public Attachment[] getAttachments(String projectName, String versionName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ATTACHMENTS_LIST, Attachment.class, projectName, versionName);
    }

    @Override
    public Issue[] getIssues(String projectName, String versionName) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ISSUE_LIST, Issue.class, projectName, versionName);
    }

    @Override
    public TimeEntry[] getIssueTimeEntries(String projectName, String issueId) throws RedmineServiceException {
        return getDatas(RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST, TimeEntry.class, projectName, issueId);
    }

    @Override
    public Issue[] getIssues(String projectName) throws RedmineServiceException {
        Issue[] result = getDatas(RedmineRestClient.GET_PROJECT_ISSUES, Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getOpenedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = getDatas(RedmineRestClient.GET_PROJECT_OPENED_ISSUES, Issue.class, projectName);
        return result;
    }

    @Override
    public Issue[] getClosedIssues(String projectName) throws RedmineServiceException {
        Issue[] result = getDatas(RedmineRestClient.GET_PROJECT_CLOSED_ISSUES, Issue.class, projectName);
        return result;
    }

    ///////////////////////////////////////////////////////////////////////////
    /// RedmineServiceImplementor implementation
    ///////////////////////////////////////////////////////////////////////////
    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        // Force to not be loggued
        configuration.setAnonymous(true);
        if (log.isDebugEnabled()) {
            log.debug("init configuration for " + this);
        }
        RedmineServiceImplementor result = delegateImplementor.init(configuration);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        if (log.isDebugEnabled()) {
            log.debug("init session for " + this);
        }
        checkNotLoggued(session);
        return delegateImplementor.init(session);
    }

    @Override
    public <T> T getData(String requestName, Class<T> type, Object... args) throws RedmineServiceException {
        return delegateImplementor.getData(requestName, type, args);
    }

    @Override
    public <T> T[] getDatas(String requestName, Class<T> type, Object... args) throws RedmineServiceException {
        return delegateImplementor.getDatas(requestName, type, args);
    }

    @Override
    public <T> T sendData(String requestName, Class<T> klazz, Object... args) throws RedmineServiceException {
        return delegateImplementor.sendData(requestName, klazz, args);
    }

    @Override
    public <T> T[] sendDatas(String requestName, Class<T> klazz, Object... args) throws RedmineServiceException {
        return delegateImplementor.sendDatas(requestName, klazz, args);
    }

    @Override
    public boolean isInit() {
        return delegateImplementor.isInit();
    }

    @Override
    public void destroy() throws RedmineServiceException {
        delegateImplementor.destroy();
    }

    @Override
    public void checkNotLoggued(RestClient session) throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        delegateImplementor.checkNotLoggued(session);
    }

    @Override
    public void checkLoggued() throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        delegateImplementor.checkLoggued();
    }

}
