/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.rest;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.io.rest.RestSession;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.VersionStatusEnum;
import org.nuiton.jredmine.rest.DefaultRequestBuilder;
import org.nuiton.jredmine.rest.IssueScopeRequestBuilder;
import org.nuiton.jredmine.rest.ProjectScopeRequestBuilder;
import org.nuiton.jredmine.rest.VersionScopeRequestBuilder;

public class RedmineRestClient
extends RestClient {
    private static final Log log = LogFactory.getLog(RedmineRestClient.class);
    public static final String GET_ISSUE_LIST = Issue.class.getName() + "list";
    public static final String GET_ISSUE_STATUS_LIST = IssueStatus.class.getName() + "list";
    public static final String GET_ISSUE_PRIORITY_LIST = IssuePriority.class.getName() + "list";
    public static final String GET_ISSUE_CATEGORY_LIST = IssueCategory.class.getName() + "list";
    public static final String GET_ISSUE_TIME_ENTRY_LIST = TimeEntry.class.getName() + "list";
    public static final String GET_PROJECT_LIST = Project.class.getName() + "list";
    public static final String GET_PROJECT_ISSUES = Project.class.getName() + "issues";
    public static final String GET_PROJECT_OPENED_ISSUES = Project.class.getName() + "opened-issues";
    public static final String GET_PROJECT_CLOSED_ISSUES = Project.class.getName() + "closed-issues";
    public static final String GET_USER_PROJECTS = Project.class.getName() + "forUser";
    public static final String GET_PROJECT = Project.class.getName() + "detail";
    public static final String GET_VERSION_LIST = Version.class.getName() + "list";
    public static final String GET_TRACKER_LIST = Tracker.class.getName() + "list";
    public static final String GET_ATTACHMENTS_LIST = Attachment.class.getName() + "list";
    public static final String GET_USER_LIST = User.class.getName() + "list";
    public static final String GET_NEWS_LIST = News.class.getName() + "list";
    public static final String GET_VERSION = Version.class.getName() + "detail";
    public static final String ADD_VERSION = Version.class.getName() + "add";
    public static final String UPDATE_VERSION = Version.class.getName() + "update";
    public static final String NEXT_VERSION = Version.class.getName() + "next";
    public static final String ADD_NEWS = News.class.getName() + "add";
    public static final String ADD_ATTACHMENT = Attachment.class.getName() + "add";
    public static final String ADD_ISSUE_TIME_ENTRY = TimeEntry.class.getName() + "add";
    public static final String LOGIN = "login";
    public static final String LOGOUT = "logout";
    public static final String PING = "ping";
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public RedmineRestClient() {
    }

    public RedmineRestClient(RestClientConfiguration configuration) {
        super(configuration);
    }

    protected void addDefaultRequests() {
        this.addRequestBuilder(new DefaultRequestBuilder(PING, PING));
        this.addRequestBuilder(new DefaultRequestBuilder(LOGOUT, LOGOUT));
        this.addRequestBuilder(new DefaultRequestBuilder(LOGIN, LOGIN){

            @Override
            public String[] getParameters(Object ... args) {
                String login = (String)args[0];
                String password = (String)args[1];
                return new String[]{"username", login, "password", password};
            }
        });
        this.addRequestBuilder(new DefaultRequestBuilder(GET_PROJECT_LIST, "get_projects.xml"));
        this.addRequestBuilder(new DefaultRequestBuilder(GET_USER_PROJECTS, "get_user_projects.xml"));
        this.addRequestBuilder(new DefaultRequestBuilder(GET_ISSUE_STATUS_LIST, "get_issue_statuses.xml"));
        this.addRequestBuilder(new DefaultRequestBuilder(GET_ISSUE_PRIORITY_LIST, "get_issue_priorities.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_PROJECT, "get_project.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_PROJECT_ISSUES, "get_project_issues.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_PROJECT_OPENED_ISSUES, "get_project_opened_issues.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_PROJECT_CLOSED_ISSUES, "get_project_closed_issues.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_VERSION_LIST, "get_project_versions.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_ISSUE_CATEGORY_LIST, "get_issue_categories.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_TRACKER_LIST, "get_project_trackers.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_USER_LIST, "get_project_users.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(GET_NEWS_LIST, "get_project_news.xml"));
        this.addRequestBuilder(new ProjectScopeRequestBuilder(ADD_VERSION, "add_version.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRestClient.this.getVersionEffectiveDate(version);
                String status = RedmineRestClient.this.getVersionStatus(version);
                return new String[]{"version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder(new ProjectScopeRequestBuilder(UPDATE_VERSION, "update_version.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRestClient.this.getVersionEffectiveDate(version);
                String status = RedmineRestClient.this.getVersionStatus(version);
                return new String[]{"version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder(new ProjectScopeRequestBuilder(NEXT_VERSION, "next_version.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                Version version = (Version)args[1];
                String date = RedmineRestClient.this.getVersionEffectiveDate(version);
                String status = RedmineRestClient.this.getVersionStatus(version);
                String oldVersionName = (String)args[2];
                return new String[]{"oldVersionName", oldVersionName, "version[name]", version.getName(), "version[description]", version.getDescription(), "version[effective_date]", date, "version[status]", status};
            }
        });
        this.addRequestBuilder(new ProjectScopeRequestBuilder(ADD_NEWS, "add_news.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                News news = (News)args[1];
                return new String[]{"news[title]", news.getTitle(), "news[summary]", news.getSummary(), "news[description]", news.getDescription()};
            }
        });
        this.addRequestBuilder(new VersionScopeRequestBuilder(GET_VERSION, "get_version.xml"));
        this.addRequestBuilder(new VersionScopeRequestBuilder(GET_ISSUE_LIST, "get_version_issues.xml"));
        this.addRequestBuilder(new VersionScopeRequestBuilder(GET_ATTACHMENTS_LIST, "get_version_attachments.xml"));
        this.addRequestBuilder(new VersionScopeRequestBuilder(ADD_ATTACHMENT, "add_version_attachment.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                String versionId = (String)args[1];
                Attachment attachment = (Attachment)args[2];
                return new String[]{"version_name", versionId, "attachment[description]", attachment.getDescription()};
            }

            @Override
            public Map<String, File> getAttachments(Object ... args) {
                HashMap<String, File> upload = new HashMap<String, File>();
                Attachment attachment = (Attachment)args[2];
                upload.put("attachment[file]", attachment.getToUpload());
                return upload;
            }
        });
        this.addRequestBuilder(new IssueScopeRequestBuilder(GET_ISSUE_TIME_ENTRY_LIST, "get_issue_times.xml"));
        this.addRequestBuilder(new IssueScopeRequestBuilder(ADD_ISSUE_TIME_ENTRY, "add_issue_time.xml"){

            @Override
            public String[] getParameters(Object ... args) {
                String issueId = (String)args[1];
                TimeEntry timeEntry = (TimeEntry)args[2];
                Date d = timeEntry.getSpentOn();
                if (d == null) {
                    d = new Date();
                }
                String date = RedmineRestClient.this.DATE_FORMAT.format(d);
                return new String[]{"issue_id", issueId, "time_entry[activity_id]", timeEntry.getActivityId() + "", "time_entry[spent_on]", date, "time_entry[hours]", timeEntry.getHours() + "", "time_entry[comments]", timeEntry.getComments() == null ? "" : timeEntry.getComments()};
            }
        });
    }

    protected void open(RestSession session) throws IOException {
        this.ping(session);
        if (!this.configuration.isAnonymous()) {
            this.login(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(RestSession session) throws IOException {
        if (session == null) {
            return;
        }
        try {
            RestRequest request = this.getRequest(LOGOUT, new Object[0]);
            session.setOpen(false);
            session.doRequest(request);
        }
        finally {
            session.close();
        }
    }

    protected void ping(RestSession session) throws IOException {
        try {
            RestRequest request = this.getRequest(PING, new Object[0]);
            HttpMethod gm = session.doRequest(request);
            StatusLine sl = gm.getStatusLine();
            int statusCode = sl.getStatusCode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
            }
            if (statusCode != 200) {
                gm.releaseConnection();
                throw new IOException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
            }
            String content = gm.getResponseBodyAsString();
            boolean ok = PING.equals(content);
            if (!ok) {
                throw new IOException("can not connect to " + this.configuration.getRestUrl());
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("could not ping " + this.configuration.getRestUrl() + " for reason " + ex.getMessage(), ex);
        }
    }

    protected void login(RestSession session) throws IOException {
        RestRequest request = this.getRequest(LOGIN, new Object[]{this.configuration.getRestUsername(), this.configuration.getRestPassword()});
        HttpMethod gm = session.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode != 200) {
            gm.releaseConnection();
            throw new IOException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
    }

    protected String getVersionStatus(Version version) {
        String status = version.getStatus();
        if (StringUtils.isEmpty((String)status)) {
            status = VersionStatusEnum.open.name();
        }
        return status;
    }

    protected String getVersionEffectiveDate(Version version) {
        return version.getEffectiveDate() == null ? "" : this.DATE_FORMAT.format(version.getEffectiveDate());
    }
}

