/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.AbstractJaxxMojo;
import org.nuiton.jaxx.NodeItem;
import org.nuiton.jaxx.TemplateGenerator;
import org.nuiton.util.FileUtil;
import org.nuiton.util.SortedProperties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JaxxHelpGeneratorMojo
extends AbstractJaxxMojo {
    protected File target;
    protected String locale;
    protected String packageName;
    protected String helpsetFileName;
    protected String mapFileName;
    protected String indexFileName;
    protected String tocFileName;
    protected String i8nFileName;
    protected File helpSetTemplate;
    protected File mapTemplate;
    protected File indexTemplate;
    protected File tocTemplate;
    protected File contentTemplate;
    protected File i18nTemplate;
    protected Properties helpIds;
    private static final String AUTOREMOVE_LINE = "REMOVE THS LINE TO DISABLE AUTO-REGENERATE THE FILE";

    @Override
    public void init() throws Exception {
        if (this.project != null && ("pom".equals(this.project.getPackaging()) || "site".equals(this.project.getPackaging()))) {
            this.skip = true;
            this.getLog().info((CharSequence)("skip generate goal for packaging " + this.project.getPackaging()));
            return;
        }
        if (!this.helpIdStore.exists()) {
            this.skip = true;
            this.getLog().info((CharSequence)("no helpIdStore to react at " + this.helpIdStore));
            return;
        }
        if (this.locale == null) {
            throw new MojoFailureException("you must set the bundles property.");
        }
        if (this.target == null) {
            throw new MojoFailureException("you must set the target property.");
        }
        this.checkResource(this.helpSetTemplate);
        this.checkResource(this.mapTemplate);
        this.checkResource(this.indexTemplate);
        this.checkResource(this.tocTemplate);
        this.checkResource(this.contentTemplate);
        if (!this.target.exists()) {
            this.getLog().info((CharSequence)("mkdir " + this.target));
            this.target.mkdirs();
        }
        this.helpIds = new SortedProperties();
        FileInputStream stream = new FileInputStream(this.helpIdStore);
        this.helpIds.load(stream);
        ((InputStream)stream).close();
        if (this.helpIds.isEmpty()) {
            this.getLog().warn((CharSequence)"no helpIds detected, will skip.");
            this.skip = true;
            return;
        }
        this.skip = false;
    }

    @Override
    public void doAction() throws Exception {
        if (this.i18nable) {
            ArrayList<URL> lUrls = new ArrayList<URL>();
            List resources = this.project.getResources();
            for (Object o : resources) {
                Resource resource = (Resource)o;
                lUrls.add(new File(resource.getDirectory()).toURI().toURL());
            }
            I18n.setExtraURL((URL[])lUrls.toArray(new URL[lUrls.size()]));
            I18n.init((String)this.locale, null);
        }
        Properties env = new Properties();
        env.put("helpSetName", this.helpSetName);
        env.put("helpSetFileName", this.helpsetFileName);
        env.put("mapFileName", this.mapFileName);
        env.put("indexFileName", this.indexFileName);
        env.put("tocFileName", this.tocFileName);
        env.put("separator", "    ");
        env.put("autoremoveLine", AUTOREMOVE_LINE);
        int touchedFiles = 0;
        File file = new File(this.target, this.helpsetFileName);
        boolean doCreate = this.generateHelSetFile(file, env);
        if (doCreate) {
            ++touchedFiles;
        }
        file = new File(this.target, this.mapFileName);
        Properties mergedHelpIds = this.generateMapFile(file, env);
        ++touchedFiles;
        file = new File(this.target, this.indexFileName);
        NodeItem indexRootItem = this.generateIndexFile(file, env);
        ++touchedFiles;
        file = new File(this.target, this.tocFileName);
        NodeItem tocRootItem = this.generateTocFile(file, env);
        ++touchedFiles;
        TemplateGenerator gen = this.prepareGenerator(this.contentTemplate);
        Enumeration<Object> keys = this.helpIds.keys();
        while (keys.hasMoreElements()) {
            String content;
            String key = (String)keys.nextElement();
            String url = (String)this.helpIds.get(key);
            url = this.helpSetName + File.separator + url;
            File f = new File(this.target, url);
            boolean exist = f.exists();
            if (exist && !(content = FileUtil.readAsString((File)f)).contains(AUTOREMOVE_LINE)) {
                if (!this.verbose) continue;
                this.getLog().debug((CharSequence)("skip existing file " + f));
                continue;
            }
            f.getParentFile().mkdirs();
            if (this.verbose) {
                if (exist) {
                    this.getLog().info((CharSequence)("regenerate content file " + f));
                } else {
                    this.getLog().info((CharSequence)("generate   content file " + f));
                }
            }
            env.put("helpId", key);
            String i18n = this.helpsetI18nPrefix + key + this.helpsetTitleI18nSuffix;
            env.put("helpIdTitle", I18n._((String)i18n));
            env.put("helpIdUrl", url);
            gen.generate(env, f);
            ++touchedFiles;
        }
        String path = this.packageName.replaceAll("\\.", File.separator);
        path = path + File.separator + this.i8nFileName;
        file = new File(this.outJava, path);
        this.generateI18nFile(file, env, mergedHelpIds, indexRootItem, tocRootItem);
        this.getLog().info((CharSequence)(++touchedFiles + " file(s) treated."));
    }

    protected void generateI18nFile(File file, Properties env, Properties mergedHelpIds, NodeItem indexRootItem, NodeItem tocRootItem) throws Exception {
        boolean create;
        boolean bl = create = !file.exists();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Object k : mergedHelpIds.keySet()) {
            String key = this.helpsetI18nPrefix + k + this.helpsetTitleI18nSuffix;
            keys.add(key);
        }
        indexRootItem.extractI18n(keys, this.helpsetI18nPrefix, this.helpsetIndexI18nSuffix);
        tocRootItem.extractI18n(keys, this.helpsetI18nPrefix, this.helpsetTocI18nSuffix);
        env.put("keys", keys);
        env.put("packageName", this.packageName);
        String className = file.getName();
        int index = className.lastIndexOf(".");
        className = className.substring(0, index);
        env.put("className", className);
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate i18n java file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate i18n java file " + file));
            }
        }
        this.doGen(this.i18nTemplate, file, env);
    }

    protected boolean generateHelSetFile(File file, Properties env) throws Exception {
        String content;
        if (file.exists() && !(content = FileUtil.readAsString((File)file)).contains(AUTOREMOVE_LINE)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip existing helpset main file " + file));
            }
            return false;
        }
        if (this.verbose) {
            if (file.exists()) {
                this.getLog().info((CharSequence)("regenerate helpset main file " + file));
            } else {
                this.getLog().info((CharSequence)("generate helpset main file " + file));
            }
        }
        this.doGen(this.helpSetTemplate, file, env);
        return true;
    }

    protected Properties generateMapFile(File file, Properties env) throws Exception {
        boolean create;
        Object mergedHelpIds = null;
        if (file.exists()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("loading existing helpset map file " + file));
            }
            mergedHelpIds = this.getExistingHelpIds(file);
            create = false;
        } else {
            mergedHelpIds = new SortedProperties();
            create = true;
        }
        for (Object k : this.helpIds.keySet()) {
            ((Properties)mergedHelpIds).put(k, this.helpSetName + "/" + this.helpIds.get(k));
        }
        if (!((Properties)mergedHelpIds).contains("top")) {
            String topUrl = this.helpSetName + ".html";
            this.helpIds.put("top", topUrl);
            ((Properties)mergedHelpIds).put("top", this.helpSetName + "/" + topUrl);
            if (this.verbose) {
                this.getLog().debug((CharSequence)("add top entry with url " + topUrl));
            }
        }
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset map file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset map file " + file));
            }
        }
        env.put("helpIds", mergedHelpIds);
        this.doGen(this.mapTemplate, file, env);
        env.remove("helpIds");
        return mergedHelpIds;
    }

    protected NodeItem generateIndexFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = this.getExistingItems("indexitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpSetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.verbose) continue;
            this.getLog().debug((CharSequence)("index " + k + " : " + toc));
        }
        rootItem.applyI18n(this.helpsetI18nPrefix, this.helpsetIndexI18nSuffix);
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset index file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset index file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.indexTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    protected NodeItem generateTocFile(File file, Properties env) throws Exception {
        boolean create;
        NodeItem rootItem = null;
        if (file.exists()) {
            create = false;
            rootItem = this.getExistingItems("tocitem", file);
        } else {
            create = true;
        }
        if (rootItem == null) {
            rootItem = new NodeItem("top", this.helpSetName);
        }
        for (Object k : this.helpIds.keySet()) {
            NodeItem toc = rootItem.findChild(k + "");
            if (!this.verbose) continue;
            this.getLog().debug((CharSequence)("toc " + k + " : " + toc));
        }
        rootItem.applyI18n(this.helpsetI18nPrefix, this.helpsetTocI18nSuffix);
        if (this.verbose) {
            if (create) {
                this.getLog().info((CharSequence)("generate helpset toc file " + file));
            } else {
                this.getLog().info((CharSequence)("udpate helpset toc file " + file));
            }
        }
        env.put("rootItem", rootItem);
        this.doGen(this.tocTemplate, file, env);
        env.remove("rootItem");
        return rootItem;
    }

    protected void doGen(File template, File f, Properties env) throws Exception {
        TemplateGenerator gen = this.prepareGenerator(template);
        gen.generate(env, f);
    }

    protected TemplateGenerator prepareGenerator(File template) throws Exception {
        URL templateURL = this.getTemplate(template);
        if (this.verbose) {
            this.getLog().info((CharSequence)("using template " + templateURL));
        }
        TemplateGenerator gen = new TemplateGenerator(this.project, templateURL);
        return gen;
    }

    protected URL getTemplate(File f) throws IOException {
        URL r = null;
        Object s = null;
        r = f.exists() ? f.toURI().toURL() : ((Object)((Object)this)).getClass().getResource(f.toString());
        return r;
    }

    protected void checkResource(File f) throws MojoFailureException {
        InputStream r;
        if (!f.exists() && (r = ((Object)((Object)this)).getClass().getResourceAsStream(f.toString())) == null) {
            throw new MojoFailureException("could not find ressource " + f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getExistingHelpIds(File file) throws SAXException, IOException {
        SortedProperties result = new SortedProperties();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(new ContentHandlerAdapter((Properties)result){
            String target;
            String url;
            final /* synthetic */ Properties val$result;
            {
                this.val$result = properties;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if ("mapID".equals(localName)) {
                    this.target = atts.getValue("target");
                    this.url = atts.getValue("url");
                    if (JaxxHelpGeneratorMojo.this.verbose) {
                        JaxxHelpGeneratorMojo.this.getLog().debug((CharSequence)("detect map entry : " + this.target + " : " + this.url));
                    }
                    this.val$result.put(this.target, this.url);
                }
            }
        });
        FileInputStream s = new FileInputStream(file);
        try {
            parser.parse(new InputSource(s));
        }
        finally {
            ((InputStream)s).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeItem getExistingItems(String tagName, File file) throws SAXException, IOException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        NodeItemHandler handler = new NodeItemHandler(tagName);
        parser.setContentHandler(handler);
        NodeItem rootItem = null;
        FileInputStream s = new FileInputStream(file);
        try {
            parser.parse(new InputSource(s));
            rootItem = handler.rootItem;
        }
        finally {
            ((InputStream)s).close();
        }
        return rootItem;
    }

    static class ContentHandlerAdapter
    implements ContentHandler {
        ContentHandlerAdapter() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    static class NodeItemHandler
    extends ContentHandlerAdapter {
        NodeItem rootItem;
        NodeItem currentItem;
        final Stack<NodeItem> stack;
        final String tagName;

        public NodeItemHandler(String tagName) {
            this.tagName = tagName;
            this.stack = new Stack();
        }

        @Override
        public void startDocument() throws SAXException {
            this.rootItem = new NodeItem("top", null);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.tagName.equals(localName)) {
                String target = atts.getValue("target");
                String text = atts.getValue("text");
                if (this.currentItem == null) {
                    if (this.rootItem.getTarget().equals(target)) {
                        this.currentItem = this.rootItem;
                    } else {
                        this.stack.push(this.rootItem);
                        this.currentItem = new NodeItem(target, text);
                        this.rootItem.addChild(this.currentItem);
                    }
                } else {
                    NodeItem newItem = new NodeItem(target, text);
                    this.currentItem.addChild(newItem);
                    this.currentItem = newItem;
                }
                this.currentItem.adjustTarget();
                this.stack.push(this.currentItem);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.tagName.equals(localName)) {
                this.stack.pop();
                if (!this.stack.isEmpty()) {
                    this.currentItem = this.stack.peek();
                }
            }
        }
    }
}

