/*
 * #%L
 * JAXX :: Widgets
 * $Id: KeyStrokeCellEditor.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.5/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/cell/KeyStrokeCellEditor.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.cell;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.swing.editor.KeyStrokeEditor;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class KeyStrokeCellEditor extends AbstractCellEditor
        implements TableCellEditor {

    protected KeyStrokeEditor keyStrokeEditor;

    public KeyStrokeCellEditor() {
        keyStrokeEditor = new KeyStrokeEditor();
        keyStrokeEditor.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        keyStrokeEditor.setKeyStroke((KeyStroke) value);
        return keyStrokeEditor;
    }

    @Override
    public Object getCellEditorValue() {
        return keyStrokeEditor.getKeyStroke();
    }
}
