/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.config;

import com.google.common.base.Supplier;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.model.CallBackFinalizer;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModelBuilder;
import jaxx.runtime.swing.editor.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;

public class ConfigUIHelper {
    public static final Log log = LogFactory.getLog(ConfigUIHelper.class);
    protected final ConfigUIModelBuilder modelBuilder = new ConfigUIModelBuilder();
    protected ConfigUIModel model;
    protected ConfigUI ui;

    public ConfigUIHelper(Supplier<ApplicationConfig> config) {
        this.modelBuilder.createModel(config);
    }

    public ConfigUIHelper(ApplicationConfig config) {
        this.modelBuilder.createModel(config);
    }

    public ConfigUIModel getModel() {
        if (this.model == null) {
            this.model = this.modelBuilder.flushModel();
        }
        return this.model;
    }

    public void addCategory(String categoryName, String categoryLabel) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addCategory(categoryName, categoryLabel);
    }

    public void addOption(ApplicationConfig.OptionDef def) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addOption(def);
    }

    public void addOption(ApplicationConfig.OptionDef def, String propertyName) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addOption(def, propertyName);
    }

    public void setOptionPropertyName(String propertyName) throws IllegalStateException, NullPointerException {
        this.modelBuilder.setOptionPropertyName(propertyName);
    }

    public void setOptionEditor(TableCellEditor editor) throws IllegalStateException, NullPointerException {
        this.modelBuilder.setOptionEditor(editor);
    }

    public void registerCallBack(String name, String description, Icon icon, Runnable action) {
        this.modelBuilder.registerCallBack(name, description, icon, action);
    }

    public void setOptionCallBack(String name) {
        this.modelBuilder.setOptionCallBack(name);
    }

    public void setModel(ConfigUIModel model) throws IllegalStateException {
        this.modelBuilder.setModel(model);
    }

    public void setCategory(CategoryModel categoryModel) throws IllegalStateException {
        this.modelBuilder.setCategory(categoryModel);
    }

    public void setOption(OptionModel optionModel) throws IllegalStateException {
        this.modelBuilder.setOption(optionModel);
    }

    public void setFinalizer(CallBackFinalizer finalizer) {
        this.modelBuilder.setFinalizer(finalizer);
    }

    public void setCloseAction(Runnable runnable) {
        this.modelBuilder.setCloseAction(runnable);
    }

    public ConfigUI buildUI(JAXXContext parentContext, String defaultCategory) {
        ConfigUIModel model = this.getModel();
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)parentContext).add((Object)model);
        this.ui = new ConfigUI((JAXXContext)tx);
        this.ui.init(defaultCategory);
        return this.ui;
    }

    public void displayUI(Frame parentUI, boolean undecorated) {
        this.ui.getHandler().displayUI(parentUI, undecorated);
    }
}

