/*
 * #%L
 * JAXX :: Widgets
 * $Id: JAXXWidgetUtil.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.18/jaxx-widgets/src/main/java/jaxx/runtime/swing/JAXXWidgetUtil.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.cell.DateCellEditor;
import jaxx.runtime.swing.editor.cell.FileCellEditor;
import jaxx.runtime.swing.editor.cell.KeyStrokeCellEditor;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DateCellRenderer;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class JAXXWidgetUtil extends SwingUtil {

    public static TableCellRenderer newDateTableCellRenderer(TableCellRenderer renderer) {
        return newDateTableCellRenderer(renderer, null);
    }

    public static TableCellRenderer newDateTableCellRenderer(TableCellRenderer renderer, String datePattern) {
        return new DateCellRenderer(renderer, datePattern);
    }

    public static TableCellEditor newDateTableCellEditor() {
        return new DateCellEditor();
    }

    public static TableCellEditor newFileTableCellEditor() {
        return new FileCellEditor();
    }

    public static TableCellEditor newKeyStrokeTableCellEditor() {
        return new KeyStrokeCellEditor();
    }

    public static <E extends Number> NumberCellEditor<E> newNumberTableCellEditor(Class<E> type, boolean useSign) {
        return new NumberCellEditor<E>(type, useSign);
    }
}
