/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.bean;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class BeanComboBox<O> extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JTOOL_BAR0_VISIBLE = "$JToolBar0.visible";
    private static final String BINDING_$JTOOL_BAR1_VISIBLE = "$JToolBar1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz28bRRSemDiO4yRtCY0aEVBoIxBCslskEJBAixulSXBLiA2qagl11juxp9rsLDuz8VZCiAsXTkj8A3DvpRLiwgEhkFAvSBy4IP4FhDhwRbw36/V6zXq9sD6s7ffje997894b+8HvpChd8sw96vtV17MVP2HVgzdv337buMc6aofJjssdJVwSvGYKpNAmFXMol4pcajfQvTZwr10XJ46wmT3ivdUgC1Ldt5jsMaYUeSru0ZGy1hyqt3zHc0PUIakk1C/+/KPwmfnxlwVCfAfYPQ2pbEzzijKZbZACNxV5HCKd0ppF7S7QcLndBb5LKLtuUSlv0RP2AfmIlBpkzqEugClyMXvKGkP7+44ipc0WNSx2WZEXYkRlH8JWmcnBtWowalfr8ABcQ9SF7zgaYU6RReopgeEsppgi55BlFZlX60JY4BKZVlx2ylzJmsJVKFqOVGXZE/0jJtm4YgkVO6wjXApExpTzSA/Zj8sdVzjMVfcVORvxCSoZWc1iVjGLoMdGcpPMAgEz9xU7Qdl6pCty22R+LOF9W7Euc0cimFRRRZa1iae4VW1wOYJf0hgMWvZiQu2x6+ueUsK+4QrPGS0WFFDLUPDcCF6P2qYFiZMX/8NZ7gVOEcxKmHYLTrDFnRbkiaq1yGTVFqo51WrZEY7ntLiyWIJ2gV95xT502TH3xzRF7QdRsHB+WI5DFN5ktjceAPupQQ1mweTEPLQQTV8aesxh7d4F7I2Y5RE1uQiKjRHC84785tFvR/Rt/P56XLe4edBkMIjYoZfHWQ81cZ8FzXxI8LXJiFdQVh/z3jzAqtcpxnsiFm8gR8Ny1DGbB0FyYL4SMw/EaHYjyrWDnWEI6O7zMeOwY+LgERlNdT+uPdOBpuyy4QgrsjbGt9u1WETj0IGd+WSsfWEbV6NtHK3LmTYpup6F83Oh/e8FfgSqYHVfGFvdCKi1f6+u/PLNb1/thvv6EsQ+n2g6ct3AHh3sF46hzwTLGse7dpM6W22YTz0Z+i5aTyDWHKiBHMQ7F22HPSp7AFEs/frd96t3f36MFHbJgiWouUvRfp+UVc+FKgjL9J2r1zSjxf48PM8iN5gHT7KRcYR52Oa2xW22QRVsP8NT7A0fCrKeUJAhK6P8418rzYfXwqLMAMm1ieZRYYp3yFwQTV9jgxsq8dqqOJJ5pohuoqS7aQbfnw333h39fD8p66VwX71HLQ8aZHkb9+6GAdsVWgwSRk9DZ4KfTA38/FRgFN/FB/2/CLBuDOGaTE8jT0Z5OQPKLO8EwzEB49UsGGqwgSdkMx0Dxf0UFtsZWFSM6EJLIZMFaj489VyUUPxhTibFU+y73DTSans1E8InKYlkQ/g0N4e0YmZD+DwXB1gHwcwdUm4PumMCnb0MYOVj2L/D35g5gEqnXPIBzITkpsNMa5O3shBhNqaTNjZZYBaPRceT04ucBaussaYUOQtQRcV/i+aAiv23mFCnW5kO7NvcCI9yIST8j8nF5kFKZd/JhPAwN8LXKVlkQ0gbo2YmhB9SssiG8Cg3wk9TEP4BOMUB4k8RAAA=";
    private static final Log log = LogFactory.getLog(BeanComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoComplete;
    protected Object bean;
    protected JToggleButton changeDecorator;
    protected JComboBox combobox;
    protected List<O> data;
    protected Boolean editable;
    protected BeanComboBoxHandler<O> handler;
    protected String i18nPrefix;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JLabel popupSortLabel;
    protected String popupTitleText;
    protected String property;
    protected Boolean reverseSort;
    protected Object selectedItem;
    protected String selectedToolTipText;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanComboBox<O> $Table0 = this;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JToolBar $JToolBar0;
    private JButton $JButton0;
    private JToolBar $JToolBar1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBox() {
        $initialize();
    }

    public BeanComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedItem(null);
    }

    public void doActionPerformed__on__changeDecorator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().togglePopup();
    }

    public void doFocusGained__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        combobox.requestFocus();
    }

    public void doFocusGained__on__combobox(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doFocusLost__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doItemStateChanged__on__combobox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedItem(combobox.getSelectedItem());
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoComplete() {
        return autoComplete;
    }

    public Object getBean() {
        return bean;
    }

    public JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public JComboBox getCombobox() {
        return combobox;
    }

    public List<O> getData() {
        return data;
    }

    public Boolean getEditable() {
        return editable;
    }

    public BeanComboBoxHandler<O> getHandler() {
        return handler;
    }

    public String getI18nPrefix() {
        return i18nPrefix;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public String getPopupTitleText() {
        return popupTitleText;
    }

    public String getProperty() {
        return property;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public Object getSelectedItem() {
        return selectedItem;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public Boolean isAutoComplete() {
        return autoComplete !=null && autoComplete;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoComplete(Boolean autoComplete) {
        Boolean oldValue = this.autoComplete;
        this.autoComplete = autoComplete;
        firePropertyChange(PROPERTY_AUTO_COMPLETE, oldValue, autoComplete);
    }

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setI18nPrefix(String i18nPrefix) {
        String oldValue = this.i18nPrefix;
        this.i18nPrefix = i18nPrefix;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, i18nPrefix);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupTitleText(String popupTitleText) {
        String oldValue = this.popupTitleText;
        this.popupTitleText = popupTitleText;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, popupTitleText);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setSelectedItem(Object selectedItem) {
        Object oldValue = this.selectedItem;
        this.selectedItem = selectedItem;
        firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, selectedItem);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add($JSeparator0);
        popup.add(popupLabel);
        popup.add($JSeparator1);
    }

    protected void addChildrenToSortDown() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void createAutoComplete() {
        $objectMap.put("autoComplete", autoComplete = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusPainted(false);
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(_("beancombobox.action.sort.tip"));
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new JComboBox());
        
        combobox.setName("combobox");
        combobox.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__combobox"));
        combobox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__combobox"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BeanComboBoxHandler<O>(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "entitycombobox.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(_("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedItem() {
        $objectMap.put("selectedItem", selectedItem = null);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(_("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(_("bean.sort.up"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add($JToolBar1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        // inline complete setup of $JToolBar1
        $JToolBar1.add(changeDecorator);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        popup.setBorder(new TitledBorder(_("beancombobox.popup.title")));
        popupSortLabel.setIcon(SwingUtil.createActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.createActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.createActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        $JButton0.setIcon(SwingUtil.createActionIcon("combobox-reset"));
        changeDecorator.setIcon(SwingUtil.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAutoComplete();
        createReverseSort();
        createShowReset();
        createShowDecorator();
        createEditable();
        createProperty();
        createBean();
        createSelectedItem();
        createIndex();
        createData();
        createIndexes();
        createSortGroup();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createPopupLabel();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setFocusPainted(false);
        $JButton0.setFocusable(false);
        $JButton0.setToolTipText(_("beancombobox.action.reset.tip"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createCombobox();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setBorderPainted(false);
        $JToolBar1.setFloatable(false);
        createChangeDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"editable" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEditable() && isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_EDITABLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setEditable(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_FOCUSABLE, true ,"enabled" ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setFocusable(isEnabled() && isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true ,"selectedItem") {
        
            @Override
            public void processDataBinding() {
                combobox.setSelectedItem(getSelectedItem());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR1_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                $JToolBar1.setVisible(isShowDecorator());
            }
        });
    }

}