/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EntityComboBox<O> extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JTOOL_BAR0_VISIBLE = "$JToolBar0.visible";
    private static final String BINDING_$JTOOL_BAR1_VISIBLE = "$JToolBar1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS3MTRxAeC8tCfvEwNiaQKgd0yEnCnCjs4mE7DnbJiYNEQUU5ZFbblgbWO8POLF5zAA78AH4CuXOhihunVA45c8gllb+QSuWQayo9s5JGq6ytLaSDHv34+uuenm/19k+SlwH54hGNonIQ+ortQ3n7zsOH3zqPoKk2QDYDJhQPSPway5Fcg0y5PbtU5EqjqtMrnfTKOt8X3Ae/L3ulSialOvRAtgGUIp8nM5pSVmo990okwqCL2iOVhvrm779yr92XP+UIiQSyW8RWloZl2U7GqyTHXEXOYqWntOJRv4U0Aua3kO+Mtq17VMpv6D48Ic9JoUomBA0QTJHL2Vs2GCY/EooUSnXqeHBVDcxcHmDZ8lf4Qx0imsPXeCSEyZtQZJqGiusiHihQ5IzmVtZ8y2uce0B9G1qUbX5wDyQobZi1jhnt2IAmDyjSG3CeBJcpTWzQLgIuIFCHipy2ReMh2ahxBykkIuL16WtAgocGcLcU7GvbZ9aXZ74LUaKrLV9BC4K+Ci5VVJFZExIq5pWrTPbhFwwG4DZeThmrXui1UCnufx3wUPSltanvetgf+XLoadyNQ23yXLenOp5BnYk6NqFd523Igs9VbWjUrOAiFHWmPEjxTrLl6/5uAHssGvDkTR5W0VOJur3uauMO+GEfhAmsUgc83PZEtDHqsGV7VqXtGuCi6zW5Ooje8yRzJkvbur81qjPOJTI6dh1YtFta2o4PBMPnEuGxWYfdsFvY1GfgcFyS+URw92yS4JbMsrasJr2nmnjoLejdBEUuDPBttTywNNYFqsrFxHqgXpWtXllBGWuQfBB6eg0XG/+XuHvoisVtcUDcNKDx/rsw99uHP95vdhVtHmvPp4b2CTIqTeeaMl36VCxn+pZUdqhYaaAmmB00an0phVit40ZyWO+MvWR3qWwjRL7w+8+/LPz48QTJbZJJj1N3k+r4LVJU7QCnwD03ErduG0bTByfx/bTmhqsdSuhbfNy+VeZ7zIclqlBEnFDBzQgHcillID1WTvHXf+Zq7253hzKGJC8cGW4Hk/+eTMTVjNB3NDxV2KeEhNDlVqvT1HtMf5a68rFj3r9L63rC4YGrVWV2VevWkoPqhLuFneqU+6YF/e2BQbyWAXEmRtylDJXRdFJPB1vJAFbcwyPsqf0IQIWnTLIOzA+fDjPOmvFVOwLjZhYq4OuG3BFhpvd4M5TDx5wFq2iwhow5C9CUSj46RoBKPOePmNOdoTjaHI6M8GIkhJT/FCOxocdMdiMTwt7ICI+P6SIbgjgGYTMTwrNjusiG8GJkhFdDEP4D0vPGxbYMAAA=";
    private static final Log log = LogFactory.getLog(jaxx.runtime.swing.EntityComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean autoComplete;
    protected java.lang.Object bean;
    protected javax.swing.JToggleButton changeDecorator;
    protected javax.swing.JComboBox combobox;
    protected java.util.List< O > data;
    protected java.lang.Boolean editable;
    protected jaxx.runtime.swing.EntityComboBoxHandler< O > handler;
    protected java.lang.String i18nPrefix;
    protected java.lang.Integer index;
    protected jaxx.runtime.swing.JAXXButtonGroup indexes;
    protected java.lang.String notSelectedToolTipText;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.String popupTitleText;
    protected java.lang.String property;
    protected java.lang.Object selectedItem;
    protected java.lang.String selectedToolTipText;
    protected java.lang.Boolean showDecorator;
    protected java.lang.Boolean showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntityComboBox $Table0 = this;
    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JToolBar $JToolBar1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String DEFAULT_POPUP_LABEL = n_("entitycombobox.popup.label");
    public static final String DEFAULT_SELECTED_TOOLTIP = n_("entitycombobox.sort.on");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = n_("entitycombobox.sort.off");
    
    
    public void init(JXPathDecorator<O> decorator, java.util.List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntityComboBox() {
        $initialize();
    }

    public EntityComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        setSelectedItem(null);
    }

    public void doActionPerformed__on__changeDecorator(java.awt.event.ActionEvent event) {
        getHandler().togglePopup();
    }

    public void doFocusGained__on__$Table0(java.awt.event.FocusEvent event) {
        combobox.requestFocus();
    }

    public void doFocusGained__on__combobox(java.awt.event.FocusEvent event) {
        hidePopup();
    }

    public void doFocusLost__on__$Table0(java.awt.event.FocusEvent event) {
        hidePopup();
    }

    public void doItemStateChanged__on__combobox(java.awt.event.ItemEvent event) {
        setSelectedItem(combobox.getSelectedItem());
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(javax.swing.event.ChangeEvent event) {
        setIndex((Integer)indexes.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAutoComplete() {
        return autoComplete;
    }

    public java.lang.Object getBean() {
        return bean;
    }

    public javax.swing.JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public javax.swing.JComboBox getCombobox() {
        return combobox;
    }

    public java.util.List< O > getData() {
        return data;
    }

    public java.lang.Boolean getEditable() {
        return editable;
    }

    public jaxx.runtime.swing.EntityComboBoxHandler< O > getHandler() {
        return handler;
    }

    public java.lang.String getI18nPrefix() {
        return i18nPrefix;
    }

    public java.lang.Integer getIndex() {
        return index;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public java.lang.String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.String getPopupTitleText() {
        return popupTitleText;
    }

    public java.lang.String getProperty() {
        return property;
    }

    public java.lang.Object getSelectedItem() {
        return selectedItem;
    }

    public java.lang.String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public java.lang.Boolean getShowDecorator() {
        return showDecorator;
    }

    public java.lang.Boolean getShowReset() {
        return showReset;
    }

    public java.lang.Boolean isAutoComplete() {
        return autoComplete !=null && autoComplete;
    }

    public java.lang.Boolean isEditable() {
        return editable !=null && editable;
    }

    public java.lang.Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public java.lang.Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoComplete(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.autoComplete;
        this.autoComplete = newValue;
        firePropertyChange(PROPERTY_AUTO_COMPLETE, oldValue, newValue);
    }

    public void setBean(java.lang.Object newValue) {
        java.lang.Object oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setData(java.util.List< O > newValue) {
        java.util.List< O > oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setEditable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.editable;
        this.editable = newValue;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, newValue);
    }

    public void setI18nPrefix(java.lang.String newValue) {
        java.lang.String oldValue = this.i18nPrefix;
        this.i18nPrefix = newValue;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, newValue);
    }

    public void setIndex(java.lang.Integer newValue) {
        java.lang.Integer oldValue = this.index;
        this.index = newValue;
        firePropertyChange(PROPERTY_INDEX, oldValue, newValue);
    }

    public void setNotSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setPopupTitleText(java.lang.String newValue) {
        java.lang.String oldValue = this.popupTitleText;
        this.popupTitleText = newValue;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, newValue);
    }

    public void setProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.property;
        this.property = newValue;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, newValue);
    }

    public void setSelectedItem(java.lang.Object newValue) {
        java.lang.Object oldValue = this.selectedItem;
        this.selectedItem = newValue;
        firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, newValue);
    }

    public void setSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setShowDecorator(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showDecorator;
        this.showDecorator = newValue;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, newValue);
    }

    public void setShowReset(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showReset;
        this.showReset = newValue;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setFocusPainted(false);
        $JButton0.setFocusable(false);
        $JButton0.setToolTipText(_("entitycombobox.action.reset.tip"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createAutoComplete() {
        $objectMap.put("autoComplete", autoComplete = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new javax.swing.JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusPainted(false);
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(_("entitycombobox.action.sort.tip"));
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new javax.swing.JComboBox());
        
        combobox.setName("combobox");
        combobox.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__combobox"));
        combobox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__combobox"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.EntityComboBoxHandler< O >(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "entitycombobox.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new jaxx.runtime.swing.JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createSelectedItem() {
        $objectMap.put("selectedItem", selectedItem = null);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add($JToolBar1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        // inline complete setup of $JToolBar1
        $JToolBar1.add(changeDecorator);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        popup.setBorder(new TitledBorder(_("entitycombobox.popup.title")));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.createActionIcon("combobox-reset"));
        changeDecorator.setIcon(jaxx.runtime.SwingUtil.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createAutoComplete();
        createShowReset();
        createShowDecorator();
        createEditable();
        createProperty();
        createBean();
        createSelectedItem();
        createIndex();
        createData();
        createIndexes();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        create$JButton0();
        createCombobox();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new javax.swing.JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setBorderPainted(false);
        $JToolBar1.setFloatable(false);
        createChangeDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"editable" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEditable() && isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_EDITABLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setEditable(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_FOCUSABLE, true ,"enabled" ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setFocusable(isEnabled() && isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true ,"selectedItem") {
        
            @Override
            public void processDataBinding() {
                combobox.setSelectedItem(getSelectedItem());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR1_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                $JToolBar1.setVisible(isShowDecorator());
            }
        });
    }

}