/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.config;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.ColumnSelector;
import jaxx.runtime.swing.editor.config.*;
import jaxx.runtime.swing.editor.config.model.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ConfigCategoryUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uUlKrCYplMo1JUpEu04AqYcgWsckiqtNXNlOWpJDGHsnzpTxzjI7jp1aRfwBIPEnwJ0LEjdOiANnDlwQ/0KFOHBFvJld73rjLU5EDht7533f+96bed/4u5co6Qp0+xnudAzRsiVtEuNR/unTUu0ZqcuPiFsX1JFcIO9vJIEShyhlBe9did46NBU858NzBd50uE3sPvS6iaZcecaIe0KIlOjNKKLuurlKsLzecVqixxqIimP95q8/E19bX3ybQKjjgLpZKCUzDBVWMmqiBLUkmoNMpzjHsN0AGYLaDdA7rd4VGHbdXdwkn6HP0biJxhwsgEyi7MVL1hwa33Ekmrjz6DG2CVuVaC2i1G1DXoNYFLBGndvHtAHq1b8ClqTBxdle0XE00ZhEySa3CJPo/aEcOtBn2ivuqG8hzXTd5965JF0/LKSbkrjGiM91/1LSqgEypJtxCYNDSLntU95Se9LxuUzqykokIETO9eoycY0w3XB42Y/2dkGFTw52Q6POA/RLFbkYACZ1vYpJooVIcKUuONOJoymSGnGeWhevIm4Fgb1zsqa+vx4lme2NHxTeS5FRjztBSKovRKLr0WykI/OCYBW6NJDw3SBhyJYUxFVjm47wbLSk5LYKeSeIHHXxqdaT898L9EbkHMCoG+Goh7M4cghZWvBaosXDQXcow5LnC4vnfEER6tV/5tO//fjHD1s9M0hB7uuxoX1eBkPqCO4QIalKPes5QUtSltvBzvohmvTOoDa6mzHCKv4yiIN8rym4oeDGNnZPgCI5/vtPP89/8usVlNhCU4xjawur+CIcnhNo6wlnVsd58FArutqegOc1pQ2GqYbrnzYEb9lgUdPdAmcwOU+2i9XNFx3ow82YPgRiapO//J2ufP+w14sR0HbjleFhP5IHaIzajNpEW6PverFWmHJc0rJ46G5xfodiR9HxB/W+fq7HFX+tzlmraW8TbBGxT0lbooOuTdoZbwyXj5azvon0HfTsyt1MRZ3NPbUBDSLB77CNG0TktUkUAbKcpfYxF03cA6ytrkA/lZAHulHqUx4NDtkw0Umwg2Neb7negCePMYOZQaMSpk2iTDdUbHODa1rDO1vEyq680Ghb3nPpc0Al1uB+mFBueY5N8DYcxJH34hT3z/wwtVdiW7zY1flU67QleWvLSt3CqZqROmaes21g8ZgzWj+TKNcNzQ683JXYlq6xv1muFgt586hSKJdMcyNfPsqbT/IfV4DrxgkX9DlUG8O2Gsu2XSoXD0q71Qjf7iYkid270Jcv0IcZ3JK8TFTj1S2i9sozZCO/Vy0dlTcrxYNNEG8eFUrm3s6uqiAN+xDcPXnGeJtY4S6lFWMBHFaSMsRxIaF3cBJEi8Sp9e6EYUpHJRontoqETLe7sEWRS3h5xaAufKLHlFh6x/yTl/ZPHdZaDd/Jp3AwERJd9ULu+WspyTmrUqeq8QsxeENSJ7YSvXqpSvLDKsksLWViQ/Yxo5FK56JK1U10rtCUX6i3FK1zfhD9qjL1JXcBExtj+IzDJYlmPrCwxJkatS1wpw8HOEfUc+oCjOd+Eam4r+LZskPZ1Osv/4Ph7f/NcBcY/gVGp8J8YQwAAA==";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.config.ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel categoryLabel;
    protected javax.swing.JPanel categoryLabelPanel;
    protected jaxx.runtime.swing.editor.config.model.CategoryModel categoryModel;
    protected javax.swing.JTextArea description;
    protected javax.swing.JScrollPane descriptionPane;
    protected jaxx.runtime.swing.editor.config.model.ConfigUIModel model;
    protected javax.swing.JButton reset;
    protected javax.swing.JButton save;
    protected javax.swing.ListSelectionModel selectionModel;
    protected javax.swing.JTable table;
    protected jaxx.runtime.swing.editor.config.model.ConfigTableModel tableModel;
    protected javax.swing.JScrollPane tablePane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(table,
            n_("config.key"),
            n_("config.key.tip"),
            n_("config.value"),
            n_("config.value.tip"),
            n_("config.defaultValue"),
            n_("config.defaultValue.tip"));
    
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        //TODO to be continued...
        //columnSelector.setMyTable(table);
        //tablePane.setCorner(ScrollPaneConstants.UPPER_RIGHT_CORNER, columnSelector);
    }
    
    protected void updateDescriptionText() {
        OptionModel option;
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        model.reset();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        model.saveModified();
    }

    public void doTableChanged__on__tableModel(javax.swing.event.TableModelEvent event) {
        updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(javax.swing.event.ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) { updateDescriptionText(); };
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public javax.swing.JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public jaxx.runtime.swing.editor.config.model.CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public javax.swing.JTextArea getDescription() {
        return description;
    }

    public javax.swing.JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigUIModel getModel() {
        return model;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigTableModel getTableModel() {
        return tableModel;
    }

    public javax.swing.JScrollPane getTablePane() {
        return tablePane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(jaxx.runtime.swing.editor.config.model.CategoryModel newValue) {
        jaxx.runtime.swing.editor.config.model.CategoryModel oldValue = this.categoryModel;
        this.categoryModel = newValue;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, newValue);
    }

    public void setSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new javax.swing.JLabel());
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new javax.swing.JPanel());
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new javax.swing.JTextArea());
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new javax.swing.JScrollPane());
        descriptionPane.setName("descriptionPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new javax.swing.JButton());
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new javax.swing.JTable(tableModel));
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new jaxx.runtime.swing.editor.config.model.ConfigTableModel(categoryModel));
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new javax.swing.JScrollPane());
        tablePane.setName("tablePane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(_("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        jaxx.runtime.SwingUtil.setText(description, _("config.no.option.selected"));
        
        reset.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config-reset"));
        save.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}