package jaxx.runtime.swing.editor.config.model;

import javax.swing.*;
import java.util.ArrayList;
import java.util.List;

/**
 * A call back with his attached options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class CallBackEntry {

    protected final String name;
    protected final String description;
    protected final Icon icon;
    protected final Runnable action;
    protected List<OptionModel> options;

    public CallBackEntry(String name,
                         String description,
                         Icon icon,
                         Runnable action) {
        this.description = description;
        this.icon = icon;
        options = new ArrayList<OptionModel>();
        this.name = name;
        this.action = action;
    }

    public Runnable getAction() {
        return action;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public Icon getIcon() {
        return icon;
    }

    public List<OptionModel> getOptions() {
        // always send a copy
        return new ArrayList<OptionModel>(options);
    }

    protected void addOption(OptionModel option) {
        options.add(option);

    }
}
